/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.reflections.vfs;

import com.tvd12.reflections.Reflections;
import com.tvd12.reflections.util.AbstractIterator;
import com.tvd12.reflections.vfs.Vfs;
import com.tvd12.reflections.vfs.ZipFile;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ZipDir
implements Vfs.Dir {
    final java.util.zip.ZipFile jarFile;

    public ZipDir(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    @Override
    public String getPath() {
        return this.jarFile.getName();
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        return new Iterable<Vfs.File>(){

            @Override
            public Iterator<Vfs.File> iterator() {
                return new AbstractIterator<Vfs.File>(){
                    final Enumeration<? extends ZipEntry> entries;
                    {
                        this.entries = ZipDir.this.jarFile.entries();
                    }

                    @Override
                    protected Vfs.File computeNext() {
                        while (this.entries.hasMoreElements()) {
                            ZipEntry entry = this.entries.nextElement();
                            if (entry.isDirectory()) continue;
                            return new ZipFile(ZipDir.this, entry);
                        }
                        return (Vfs.File)this.endOfData();
                    }
                };
            }
        };
    }

    @Override
    public void close() {
        block2: {
            try {
                this.jarFile.close();
            }
            catch (IOException e) {
                if (Reflections.log == null) break block2;
                Reflections.log.warn("Could not close JarFile", (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.jarFile.getName();
    }
}

