/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.config;

import com.tvd12.ezyfox.bean.EzyBeanConfig;
import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.bean.annotation.EzyConfigurationAfter;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Set;
import org.youngmonkeys.ezyplatform.admin.config.AdminScriptsRunner;
import org.youngmonkeys.ezyplatform.admin.jdbc.AdminSqlScriptsRunner;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.model.RunScriptHistoryModel;
import org.youngmonkeys.ezyplatform.admin.service.AdminRunScriptHistoryService;

@EzyConfigurationAfter(priority=-32768)
public class AdminScriptsPostConfig
extends EzyLoggable
implements EzyBeanConfig {
    @EzyAutoBind
    private AdminModuleManager moduleManager;
    @EzyAutoBind
    private AdminScriptsRunner scriptsRunner;
    @EzyAutoBind
    private AdminSqlScriptsRunner sqlScriptsRunner;
    @EzyAutoBind
    private AdminRunScriptHistoryService runScriptHistoryService;

    public void config() {
        this.saveRunScripts();
        this.runProjectScripts();
    }

    private void saveRunScripts() {
        for (String scriptFile : this.scriptsRunner.getRunScriptFiles()) {
            this.runScriptHistoryService.saveHistory(RunScriptHistoryModel.builder().moduleName("ezyplatform").moduleType("PLATFORM").scriptName(scriptFile).build());
        }
    }

    private void runProjectScripts() {
        Set<String> projectNames = this.moduleManager.getActivatedProjectNames();
        for (String projectName : projectNames) {
            try {
                this.sqlScriptsRunner.runProjectScripts(projectName);
            }
            catch (Exception e) {
                this.logger.info("run sql scripts of project: {} failed", (Object)projectName, (Object)e);
            }
        }
    }

    public void setModuleManager(AdminModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public void setScriptsRunner(AdminScriptsRunner scriptsRunner) {
        this.scriptsRunner = scriptsRunner;
    }

    public void setSqlScriptsRunner(AdminSqlScriptsRunner sqlScriptsRunner) {
        this.sqlScriptsRunner = sqlScriptsRunner;
    }

    public void setRunScriptHistoryService(AdminRunScriptHistoryService runScriptHistoryService) {
        this.runScriptHistoryService = runScriptHistoryService;
    }
}

