/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminNotificationControllerService;
import org.youngmonkeys.ezyplatform.admin.response.AdminNotificationResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminNotificationService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminCommonValidator;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.response.CountResponse;

@Api
@Authenticated
@Controller(value="/api/v1")
public class AdminApiNotificationsController {
    private final AdminNotificationService notificationService;
    private final AdminNotificationControllerService notificationControllerService;
    private final AdminCommonValidator commonValidator;

    @DoGet(value="/admins/me/notifications/count")
    public CountResponse adminsMeNotificationsCountGet(@AdminId long adminId) {
        return new CountResponse(this.notificationService.countAdminUnreadNotifications(adminId));
    }

    @DoGet(value="/admins/me/notifications")
    public PaginationModel<AdminNotificationResponse> adminsMeNotificationsGet(@AdminId long adminId, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="5") int limit) {
        this.commonValidator.validatePageSize(limit);
        return this.notificationControllerService.getAdminNotifications(adminId, nextPageToken, prevPageToken, lastPage, limit);
    }

    @DoPost(value="/admins/me/notifications/{id}/read")
    public ResponseEntity adminsMeNotificationsIdReadPost(@AdminId long adminId, @PathVariable long notificationId) {
        this.notificationService.updateAdminNotificationByRead(adminId, notificationId);
        return ResponseEntity.noContent();
    }

    @DoPost(value="/admins/me/notifications/read")
    public ResponseEntity adminsMeNotificationsReadPost(@AdminId long adminId) {
        this.notificationService.updateAllAdminNotificationsByRead(adminId);
        return ResponseEntity.noContent();
    }

    public AdminApiNotificationsController(AdminNotificationService notificationService, AdminNotificationControllerService notificationControllerService, AdminCommonValidator commonValidator) {
        this.notificationService = notificationService;
        this.notificationControllerService = notificationControllerService;
        this.commonValidator = commonValidator;
    }
}

