/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.view;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import com.tvd12.ezyhttp.server.core.view.View;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewFactory;
import org.youngmonkeys.ezyplatform.entity.ModuleType;

@Authenticated
@Controller
@EzyFeature(value="plugin_management")
public class AdminModulesController {
    private final AdminModuleManager moduleManager;
    private final AdminViewFactory viewFactory;

    @DoGet(value="/modules/add")
    public View modulesAddGet(RequestArguments arguments, @RequestParam(value="type") String moduleType, @RequestParam(value="name") String name, @RequestParam(value="keyword") String keyword) {
        return this.viewFactory.newModulesAddViewBuilder(ModuleType.of((String)moduleType)).addVariable("enableUploadButton", (Object)true).addVariable("selectedModuleName", (Object)name).addVariable("searchModulesKeyword", (Object)keyword).addVariables(arguments.getRedirectionAttributes()).build();
    }

    @DoGet(value="/modules/{moduleName}")
    public View modulesModuleNameGet(@PathVariable(value="moduleName") String moduleName) {
        ModuleType moduleType = ModuleType.ADMIN_PLUGIN;
        for (ModuleType value : ModuleType.values()) {
            if (!this.moduleManager.containsModule(value, moduleName)) continue;
            moduleType = value;
            break;
        }
        return this.viewFactory.newModuleDetailsViewBuilder(moduleType, moduleName).build();
    }

    public AdminModulesController(AdminModuleManager moduleManager, AdminViewFactory viewFactory) {
        this.moduleManager = moduleManager;
        this.viewFactory = viewFactory;
    }
}

