/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.view;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.view.View;
import org.youngmonkeys.ezyplatform.admin.mail.AdminNewPlatformMailScheduler;
import org.youngmonkeys.ezyplatform.admin.manager.AdminDataAppenderManager;
import org.youngmonkeys.ezyplatform.admin.service.AdminLanguageService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.service.AdminWebLanguageService;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewFactory;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewName;
import org.youngmonkeys.ezyplatform.annotation.AdminRoles;
import org.youngmonkeys.ezyplatform.data.AdminRolesProxy;
import org.youngmonkeys.ezyplatform.entity.DataType;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.util.StringConverters;

@Authenticated
@Controller
@EzyFeature(value="settings_management")
public class AdminSettingsController {
    private final AdminViewFactory viewFactory;
    private final AdminDataAppenderManager dataAppenderManager;
    private final AdminLanguageService adminLanguageService;
    private final AdminSettingService settingService;
    private final AdminWebLanguageService webLanguageService;
    private final AdminNewPlatformMailScheduler newPlatformMailScheduler;

    @DoGet(value="/settings")
    public View settingsGet(@AdminRoles AdminRolesProxy adminRoles, @RequestParam(value="keyword") String keyword, @RequestParam(value="dataType") DataType dataType) {
        return this.viewFactory.newSettingsViewBuilder(AdminViewName.LIST).addVariable("dataTypes", (Object)DataType.values()).addVariable("settingSearchKeyword", (Object)keyword).addVariable("settingSearchDataType", (Object)dataType).addVariable("enableAddNewButton", (Object)adminRoles.isAccessible("/api/v1/settings/add", HttpMethod.POST)).build();
    }

    @DoGet(value="/settings/regular")
    public View settingsRegularGet() {
        return (View)Reactive.multiple().register((Object)"regularSettings", this.settingService::getRegularSettings).register((Object)"ezyplatformNodeName", () -> ((AdminSettingService)this.settingService).getNodeName()).register((Object)"adminDefaultLanguageCode", () -> StringConverters.trimOrNull((String)this.adminLanguageService.getDefaultLanguageCode())).register((Object)"allowSearchUserByLikeOperator", this.settingService::isAllowSearchUserByLikeOperator).register((Object)"newPlatformMailScheduleType", this.newPlatformMailScheduler::getScheduleType).registerRx((Object)"adminLoginSettings", this.settingService.getAdminLoginSettings()).register((Object)"adminTokenExpiredTimeInDay", this.settingService::getAdminTokenExpiredTimeInDay).register((Object)"dateFormat", this.settingService::getAdminDateFormat).register((Object)"timeFormat", this.settingService::getAdminTimeFormat).register((Object)"dateTimeFormat", this.settingService::getAdminDateTimeFormat).register((Object)"dateMinuteFormat", this.settingService::getAdminDateMinuteFormat).register((Object)"allowReloadAppender", this.settingService::isAllowReloadAppender).register((Object)"adminSsoAllowedOriginsText", this.settingService::getAdminSsoAllowedOriginsText).blockingGet(it -> {
            boolean allowReloadAppender = (Boolean)it.get((Object)"allowReloadAppender");
            View.Builder viewBuilder = this.viewFactory.newSettingsViewBuilder(AdminViewName.REGULAR).addVariables(it.valueMap());
            if (allowReloadAppender) {
                viewBuilder.addVariable("dataAppenderNames", this.dataAppenderManager.getSortedDataAppenderNames());
            }
            return viewBuilder.build();
        });
    }

    @DoGet(value="/settings/website")
    public View settingsWebsiteGet() {
        return (View)Reactive.multiple().register((Object)"websiteName", () -> this.settingService.getTextValue("web_site_name")).register((Object)"websiteTitle", () -> this.settingService.getTextValue("web_site_title")).register((Object)"pageTitleSeparator", () -> this.settingService.getTextValue("web_page_title_separator")).register((Object)"websiteTagLine", () -> this.settingService.getTextValue("web_site_tagline")).register((Object)"allowSearchUserByLikeOperator", this.settingService::isWebAllowSearchUserByLikeOperator).register((Object)"userTokenExpiredTimeInDay", () -> ((AdminSettingService)this.settingService).getUserTokenExpiredTimeInDay()).register((Object)"webLanguages", () -> ((AdminWebLanguageService)this.webLanguageService).getLanguages()).register((Object)"defaultWebLanguage", this.webLanguageService::getDefaultLanguageCode).register((Object)"dateFormat", () -> ((AdminSettingService)this.settingService).getWebDateFormat()).register((Object)"timeFormat", () -> ((AdminSettingService)this.settingService).getWebTimeFormat()).register((Object)"dateTimeFormat", () -> ((AdminSettingService)this.settingService).getWebDateTimeFormat()).register((Object)"dateMinuteFormat", () -> ((AdminSettingService)this.settingService).getWebDateMinuteFormat()).blockingGet(it -> this.viewFactory.newSettingsViewBuilder(AdminViewName.WEBSITE).addVariables(it.valueMap()).build());
    }

    @DoGet(value="/settings/encryption")
    public View settingsEncryptionGet() {
        return this.viewFactory.newSettingsViewBuilder(AdminViewName.ENCRYPTION).build();
    }

    public AdminSettingsController(AdminViewFactory viewFactory, AdminDataAppenderManager dataAppenderManager, AdminLanguageService adminLanguageService, AdminSettingService settingService, AdminWebLanguageService webLanguageService, AdminNewPlatformMailScheduler newPlatformMailScheduler) {
        this.viewFactory = viewFactory;
        this.dataAppenderManager = dataAppenderManager;
        this.adminLanguageService = adminLanguageService;
        this.settingService = settingService;
        this.webLanguageService = webLanguageService;
        this.newPlatformMailScheduler = newPlatformMailScheduler;
    }
}

