/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.mail;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.youngmonkeys.ezyplatform.admin.concurrent.AdminScheduler;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEzyPlatformManager;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSpecificMailService;
import org.youngmonkeys.ezyplatform.constant.ScheduleType;

@EzySingleton
public class AdminNewPlatformMailScheduler
extends EzyLoggable {
    private final AdminScheduler scheduler;
    private final AdminEzyPlatformManager ezyPlatformManager;
    private final AdminSettingService settingService;
    private final AdminSpecificMailService specificMailService;
    private final AtomicReference<ScheduleType> scheduleTypeRef = new AtomicReference();

    public void setScheduleType(ScheduleType scheduleType) {
        this.settingService.setTextValue("admin_update_platform_mail_scheduler_type", scheduleType.toString());
        this.scheduleTypeRef.set(scheduleType);
    }

    public ScheduleType getScheduleType() {
        if (this.scheduleTypeRef.get() == null) {
            String textValue = this.settingService.getTextValue("admin_update_platform_mail_scheduler_type", ScheduleType.DAYS.toString());
            this.scheduleTypeRef.set(ScheduleType.valueOf((String)textValue));
        }
        return this.scheduleTypeRef.get();
    }

    public void start() {
        this.scheduler.scheduleAtFixRate(this::checkToSendMail, 5L, 5L, TimeUnit.SECONDS);
    }

    private void checkToSendMail() {
        try {
            this.doCheckToSendMail();
        }
        catch (Exception e) {
            this.logger.warn("send update platform mail error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckToSendMail() {
        ScheduleType scheduleType = this.getScheduleType();
        if (scheduleType == ScheduleType.NEVER) {
            return;
        }
        if (!this.ezyPlatformManager.hasNewVersion()) {
            return;
        }
        long lastSendTime = this.settingService.getLongValue("admin_last_send_update_platform_mail_time");
        long timeToSend = lastSendTime + scheduleType.getMillisSeconds();
        long currentTime = System.currentTimeMillis();
        if (currentTime >= timeToSend) {
            try {
                this.specificMailService.sendNewPlatformVersionMail(this.ezyPlatformManager.getLatestVersion());
            }
            finally {
                this.settingService.setLongValue("admin_last_send_update_platform_mail_time", currentTime);
            }
        }
    }

    public AdminNewPlatformMailScheduler(AdminScheduler scheduler, AdminEzyPlatformManager ezyPlatformManager, AdminSettingService settingService, AdminSpecificMailService specificMailService) {
        this.scheduler = scheduler;
        this.ezyPlatformManager = ezyPlatformManager;
        this.settingService = settingService;
        this.specificMailService = specificMailService;
    }
}

