/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.youngmonkeys.ezyplatform.admin.data.Menu;
import org.youngmonkeys.ezyplatform.admin.data.MenuItem;
import org.youngmonkeys.ezyplatform.admin.data.MenuSection;

@EzySingleton
public class AdminMenuManager {
    private final MenuSection topSection = new MenuSection("top");
    private final MenuSection componentsSection = new MenuSection("components");
    private final MenuSection administratorSection = new MenuSection("administrator");
    private final MenuSection extensionsSection = new MenuSection("extensions");
    private final Map<String, MenuSection> sectionByName = new HashMap<String, MenuSection>();
    private final Map<String, Menu> menuByUri = new ConcurrentHashMap<String, Menu>();
    private final Map<String, Menu> menuByModule = new ConcurrentHashMap<String, Menu>();
    private final Map<String, Menu> menuByFullName = new ConcurrentHashMap<String, Menu>();
    private final Map<String, MenuItem> menuItemByUri = new ConcurrentHashMap<String, MenuItem>();

    public AdminMenuManager() {
        this.sectionByName.put(this.topSection.getName(), this.topSection);
        this.sectionByName.put(this.componentsSection.getName(), this.componentsSection);
        this.sectionByName.put(this.administratorSection.getName(), this.administratorSection);
        this.sectionByName.put(this.extensionsSection.getName(), this.extensionsSection);
    }

    public Menu getMenuByUri(String menuUri) {
        Menu menu = this.menuByUri.get(menuUri);
        if (menu == null) {
            menu = this.menuByUri.get(this.getCorrectUri(menuUri));
        }
        return menu;
    }

    public Menu getMenuByModule(String moduleName) {
        return this.menuByModule.get(moduleName);
    }

    public Menu getMenuByFullName(String menuFullName) {
        return this.menuByFullName.get(menuFullName);
    }

    public MenuItem getMenuItemByUri(String menuItemUri) {
        MenuItem menuItem = this.menuItemByUri.get(menuItemUri);
        if (menuItem == null) {
            menuItem = this.menuItemByUri.get(this.getCorrectUri(menuItemUri));
        }
        return menuItem;
    }

    public Menu addMenu(String moduleName, String sectionName, String menuName, String menuUri, String menuIcon, boolean visible) {
        return this.menuByUri.computeIfAbsent(menuUri, k -> {
            MenuSection menuSection = this.sectionByName.getOrDefault(sectionName, this.extensionsSection);
            Menu menu = new Menu(moduleName, menuName, menuUri, menuIcon, visible);
            menuSection.addMenu(menu);
            this.menuByFullName.put(menu.getFullName(), menu);
            this.menuByModule.put(moduleName, menu);
            return menu;
        });
    }

    public void addMenuItem(String sectionName, String menuFullName, String menuItemName, String menuItemUri, String menuItemIcon, boolean visible) {
        this.menuItemByUri.computeIfAbsent(menuItemUri, k -> {
            MenuSection menuSection = this.sectionByName.getOrDefault(sectionName, this.extensionsSection);
            Menu menu = menuSection.getMenu(menuFullName);
            if (menu == null) {
                throw new NullPointerException("please call 'addMenu' method first");
            }
            MenuItem menuItem = new MenuItem(sectionName, menuFullName, menuItemName, menuItemUri, menuItemIcon, visible);
            menu.addMenuItem(menuItem);
            return menuItem;
        });
    }

    private String getCorrectUri(String uri) {
        return uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri + "/";
    }

    public MenuSection getTopSection() {
        return this.topSection;
    }

    public MenuSection getComponentsSection() {
        return this.componentsSection;
    }

    public MenuSection getAdministratorSection() {
        return this.administratorSection;
    }

    public MenuSection getExtensionsSection() {
        return this.extensionsSection;
    }
}

