/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.youngmonkeys.ezyplatform.admin.data.ProjectInstallation;

@EzySingleton
public class AdminProjectInstallationQueue {
    private final Set<String> projectNames;
    private final BlockingQueue<ProjectInstallation> queue = new LinkedBlockingQueue<ProjectInstallation>();

    public AdminProjectInstallationQueue() {
        this.projectNames = ConcurrentHashMap.newKeySet();
    }

    public boolean containsProject(String projectName) {
        return this.projectNames.contains(projectName);
    }

    public void add(ProjectInstallation installation) {
        if (this.projectNames.contains(installation.getProjectName())) {
            return;
        }
        this.projectNames.add(installation.getProjectName());
        this.queue.add(installation);
    }

    public ProjectInstallation take() throws InterruptedException {
        return this.queue.take();
    }

    public void finishInstallation(String project) {
        this.projectNames.remove(project);
    }

    public List<ProjectInstallation> getProjectsInQueue() {
        return new ArrayList<ProjectInstallation>(this.queue);
    }
}

