/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.statistics;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyhttp.client.HttpClient;
import com.tvd12.ezyhttp.client.request.PostRequest;
import com.tvd12.ezyhttp.client.request.Request;
import com.tvd12.ezyhttp.client.request.RequestEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.manager.AdminMarketUrlManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.constant.ModuleAction;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.manager.EnvironmentManager;
import org.youngmonkeys.ezyplatform.manager.EzyPlatformKeyManager;
import org.youngmonkeys.ezyplatform.manager.MarketUrlManager;
import org.youngmonkeys.ezyplatform.service.SettingService;
import org.youngmonkeys.ezyplatform.statistics.EzyPlatformStatisticsSender;

@EzySingleton
public class AdminEzyPlatformStatisticsSender
extends EzyPlatformStatisticsSender {
    private final AdminModuleManager moduleManager;
    private final AdminMarketUrlManager marketUrlManager;

    public AdminEzyPlatformStatisticsSender(AdminSettingService settingService, AdminModuleManager moduleManager, HttpClient httpClient, AdminMarketUrlManager marketUrlManager, EzyPlatformKeyManager platformKeyManager, EnvironmentManager environmentManager) {
        super(httpClient, (SettingService)settingService, (MarketUrlManager)marketUrlManager, platformKeyManager, environmentManager);
        this.moduleManager = moduleManager;
        this.marketUrlManager = marketUrlManager;
    }

    public void sendProjectActionStatistics(String projectName, String projectVersion, ModuleAction action, List<ModuleType> moduleTypes) {
        this.sendStatistics(platformKey -> {
            String platformVersion = this.environmentManager.getPlatformVersion();
            this.httpClient.request((Request)((PostRequest)new PostRequest().setURL(this.marketUrlManager.getSendProjectActionStatisticsUrl(platformVersion, projectName, projectVersion, action))).setEntity(RequestEntity.builder().header("platformKey", platformKey).body(Collections.singletonMap("moduleTypes", moduleTypes)).build()));
        });
    }

    public void sendTargetStopStatistics(String targetType) {
        this.sendStatistics(platformKey -> {
            String platformVersion = this.environmentManager.getPlatformVersion();
            this.httpClient.request((Request)((PostRequest)new PostRequest().setURL(this.marketUrlManager.getSendTargetStopStatisticsUrl(platformVersion, targetType))).setEntity(RequestEntity.builder().header("platformKey", platformKey).build()));
        });
    }

    protected Object getSendStartupStatisticsData() {
        return Collections.singletonMap("projects", this.getStatisticsProjects());
    }

    private List<StatisticsProject> getStatisticsProjects() {
        HashMap<String, StatisticsProject.Builder> projectBuilders = new HashMap<String, StatisticsProject.Builder>();
        for (Module module : this.moduleManager.getAllModules()) {
            projectBuilders.computeIfAbsent(module.getName(), k -> StatisticsProject.builder().projectName((String)k).projectVersion(module.getVersion())).addModule(module.getType(), module.isActive());
        }
        return EzyLists.newArrayList(projectBuilders.values(), StatisticsProject.Builder::build);
    }

    public static class StatisticsProject {
        private final String projectName;
        private final String projectVersion;
        private final Map<ModuleType, String> modules;

        public StatisticsProject(Builder builder) {
            this.projectName = builder.projectName;
            this.projectVersion = builder.projectVersion;
            this.modules = builder.modules;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getProjectVersion() {
            return this.projectVersion;
        }

        public Map<ModuleType, String> getModules() {
            return this.modules;
        }

        public static class Builder
        implements EzyBuilder<StatisticsProject> {
            private String projectName;
            private String projectVersion;
            private final Map<ModuleType, String> modules = new HashMap<ModuleType, String>();

            public Builder projectName(String projectName) {
                this.projectName = projectName;
                return this;
            }

            public Builder projectVersion(String projectVersion) {
                this.projectVersion = projectVersion;
                return this;
            }

            public void addModule(ModuleType moduleType, boolean activate) {
                this.modules.put(moduleType, activate ? "ACTIVATED" : "DEACTIVATED");
            }

            public StatisticsProject build() {
                return new StatisticsProject(this);
            }
        }
    }
}

