/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.validator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import org.apache.tika.config.TikaConfig;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminMediaService;
import org.youngmonkeys.ezyplatform.exception.MediaNotFoundException;
import org.youngmonkeys.ezyplatform.model.AvatarCoverImageIdsModel;
import org.youngmonkeys.ezyplatform.model.MediaModel;
import org.youngmonkeys.ezyplatform.service.SettingService;
import org.youngmonkeys.ezyplatform.validator.MediaValidator;

@EzySingleton
public class AdminMediaValidator
extends MediaValidator {
    private final AdminAdminService adminService;
    private final AdminMediaService mediaService;

    public AdminMediaValidator(TikaConfig tika, AdminAdminService adminService, AdminMediaService mediaService, SettingService settingService) {
        super(tika, settingService);
        this.adminService = adminService;
        this.mediaService = mediaService;
    }

    public void validateAdminMedia(long adminId, long mediaId) {
        MediaModel media = this.getAdminMediaById(adminId, mediaId);
        if (media == null) {
            throw new MediaNotFoundException(mediaId);
        }
    }

    public void validateAdminMedia(long adminId, String mediaName) {
        MediaModel media = this.getAdminMediaByName(adminId, mediaName);
        if (media == null) {
            throw new MediaNotFoundException(mediaName);
        }
    }

    private MediaModel getAdminMediaById(long adminId, long mediaId) {
        return this.getAdminMediaOrNull(adminId, this.mediaService.getMediaById(mediaId));
    }

    private MediaModel getAdminMediaByName(long adminId, String mediaName) {
        return this.getAdminMediaOrNull(adminId, this.mediaService.getMediaByName(mediaName));
    }

    private MediaModel getAdminMediaOrNull(long adminId, MediaModel media) {
        AvatarCoverImageIdsModel adminImageIds;
        if (media != null && media.getOwnerAdminId() != adminId && ((adminImageIds = this.adminService.getAdminAvatarCoverImageIdsById(adminId)) == null || media.getId() != adminImageIds.getAvatarImageId() && media.getId() != adminImageIds.getCoverImageId())) {
            return null;
        }
        return media;
    }
}

