/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.codec.EzyMessageHeader;
import com.tvd12.ezyfox.codec.EzyMessageToBytes;
import java.nio.ByteBuffer;

public class EzySimpleMessageToBytes
implements EzyMessageToBytes {
    public byte[] convert(EzyMessage message) {
        ByteBuffer buffer = this.newByteBuffer(message);
        this.writeHeader(buffer, message);
        this.writeSize(buffer, message);
        this.writeContent(buffer, message);
        byte[] answer = new byte[buffer.position()];
        buffer.flip();
        buffer.get(answer);
        return answer;
    }

    private void writeHeader(ByteBuffer buffer, EzyMessage message) {
        this.writeHeader(buffer, message.getHeader());
    }

    private void writeHeader(ByteBuffer buffer, EzyMessageHeader header) {
        byte headerByte = 0;
        headerByte = (byte)(headerByte | (header.isBigSize() ? 1 : 0));
        headerByte = (byte)(headerByte | (header.isEncrypted() ? 2 : 0));
        headerByte = (byte)(headerByte | (header.isCompressed() ? 4 : 0));
        headerByte = (byte)(headerByte | (header.isText() ? 8 : 0));
        buffer.put(headerByte);
    }

    private void writeSize(ByteBuffer buffer, EzyMessage message) {
        if (message.hasBigSize()) {
            buffer.putInt(message.getSize());
        } else {
            buffer.putShort((short)message.getSize());
        }
    }

    private void writeContent(ByteBuffer buffer, EzyMessage message) {
        buffer.put(message.getContent());
    }

    private ByteBuffer newByteBuffer(EzyMessage message) {
        int capacity = this.getCapacity(message);
        return ByteBuffer.allocate(capacity);
    }

    private int getCapacity(EzyMessage message) {
        return message.getByteCount();
    }
}

