/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.fetcher;

import com.tvd12.ezyfox.io.EzyMaps;
import java.util.Collection;
import java.util.Map;
import org.youngmonkeys.ezyplatform.fetcher.CommonEntityFetcher;
import org.youngmonkeys.ezyplatform.model.CommonEntityModel;
import org.youngmonkeys.ezyplatform.model.UserNameModel;
import org.youngmonkeys.ezyplatform.service.UserService;

public class CommonUserEntityFetcher
implements CommonEntityFetcher {
    private final UserService userService;

    @Override
    public CommonEntityModel getEntityById(long entityId) {
        UserNameModel model = this.userService.getUsernameById(entityId);
        return model != null ? this.toCommonEntityModel(model) : CommonEntityModel.defaultEntity(entityId, this.getEntityType());
    }

    @Override
    public Map<Long, CommonEntityModel> getEntityMapByIds(Collection<Long> entityIds) {
        return EzyMaps.newHashMapNewValues(this.userService.getUsernameMapByIds(entityIds), this::toCommonEntityModel);
    }

    protected CommonEntityModel toCommonEntityModel(UserNameModel model) {
        return CommonEntityModel.builder().id(model.getUserId()).displayName(model.getName()).url(this.getUriPrefix() + "/" + model.getUsername()).build();
    }

    protected String getUriPrefix() {
        return "/users";
    }

    @Override
    public String getEntityType() {
        return "ezy_users";
    }

    public CommonUserEntityFetcher(UserService userService) {
        this.userService = userService;
    }
}

