/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.Link;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.model.LinkModel;
import org.youngmonkeys.ezyplatform.model.MediaNameModel;
import org.youngmonkeys.ezyplatform.model.SaveLinkModel;
import org.youngmonkeys.ezyplatform.repo.LinkRepository;
import org.youngmonkeys.ezyplatform.service.LinkService;
import org.youngmonkeys.ezyplatform.service.MediaService;

public class DefaultLinkService
implements LinkService {
    private final MediaService mediaService;
    private final LinkRepository linkRepository;
    private final DefaultModelToEntityConverter modelToEntityConverter;
    private final DefaultEntityToModelConverter entityToModelConverter;

    @Override
    public void saveLink(SaveLinkModel model) {
        Link entity = (Link)this.linkRepository.findByField("linkUri", model.getLinkUri());
        if (entity == null) {
            entity = this.modelToEntityConverter.toEntity(model);
        } else {
            this.modelToEntityConverter.mergeToEntity(model, entity);
        }
        this.linkRepository.save(entity);
    }

    @Override
    public void updateLink(long linkId, SaveLinkModel model) {
        Link entity = this.getLinkByIdEntityOrThrow(linkId);
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.linkRepository.save(entity);
    }

    @Override
    public void removeLinkById(long linkId) {
        this.linkRepository.delete(linkId);
    }

    @Override
    public void removeLinkByUri(String uri) {
        this.linkRepository.deleteByLinkUri(uri);
    }

    @Override
    public boolean containsLinkByUri(String uri) {
        return this.linkRepository.containsByField("linkUri", uri);
    }

    @Override
    public LinkModel getLinkById(long linkId) {
        return this.entityToModelConverter.toModel((Link)this.linkRepository.findById(linkId), "");
    }

    @Override
    public LinkModel getLinkByIdIncludeImage(long linkId) {
        Link link = (Link)this.linkRepository.findById(linkId);
        return this.decorateLinkWithImage(link);
    }

    @Override
    public LinkModel getLinkByUri(String uri) {
        return this.entityToModelConverter.toModel((Link)this.linkRepository.findByField("linkUri", uri), "");
    }

    @Override
    public LinkModel getLinkByUriIncludeImage(String uri) {
        Link link = (Link)this.linkRepository.findByField("linkUri", uri);
        return this.decorateLinkWithImage(link);
    }

    private LinkModel decorateLinkWithImage(Link link) {
        if (link == null) {
            return null;
        }
        long imageId = link.getImageId();
        return this.entityToModelConverter.toModel(link, imageId <= 0L ? "" : MediaNameModel.getMediaUrlOrNull(this.mediaService.getMediaNameById(link.getImageId())));
    }

    protected Link getLinkByIdEntityOrThrow(long linkId) {
        Link link = (Link)this.linkRepository.findById(linkId);
        if (link == null) {
            throw new ResourceNotFoundException("link");
        }
        return link;
    }

    public DefaultLinkService(MediaService mediaService, LinkRepository linkRepository, DefaultModelToEntityConverter modelToEntityConverter, DefaultEntityToModelConverter entityToModelConverter) {
        this.mediaService = mediaService;
        this.linkRepository = linkRepository;
        this.modelToEntityConverter = modelToEntityConverter;
        this.entityToModelConverter = entityToModelConverter;
    }
}

