/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.entity;

import com.tvd12.gamebox.entity.MMOPlayer;
import com.tvd12.gamebox.entity.NormalRoom;
import com.tvd12.gamebox.entity.Player;
import com.tvd12.gamebox.handler.MMORoomUpdatedHandler;
import com.tvd12.gamebox.manager.PlayerManager;
import com.tvd12.gamebox.manager.SynchronizedPlayerManager;
import java.util.ArrayList;
import java.util.List;

public class MMORoom
extends NormalRoom {
    protected MMOPlayer master;
    protected final double distanceOfInterest;
    protected final List<MMOPlayer> playerBuffer = new ArrayList<MMOPlayer>();
    protected final List<MMORoomUpdatedHandler> roomUpdatedHandlers;

    public MMORoom(Builder builder) {
        super(builder);
        this.roomUpdatedHandlers = builder.roomUpdatedHandlers;
        this.distanceOfInterest = builder.distanceOfInterest;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlayer(Player player) {
        if (!(player instanceof MMOPlayer)) {
            throw new IllegalArgumentException("Player " + player.getName() + " must be MMOPlayer");
        }
        if (this.playerManager.containsPlayer(player)) {
            return;
        }
        MMORoom mMORoom = this;
        synchronized (mMORoom) {
            if (this.playerManager.isEmpty()) {
                this.master = (MMOPlayer)player;
            }
            super.addPlayer(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlayer(Player player) {
        if (!(player instanceof MMOPlayer)) {
            throw new IllegalArgumentException("Player " + player.getName() + " must be MMOPlayer");
        }
        MMORoom mMORoom = this;
        synchronized (mMORoom) {
            super.removePlayer(player);
            if (this.master == player) {
                this.master = this.playerManager.isEmpty() ? null : (MMOPlayer)this.playerManager.getFirstPlayer();
            }
        }
    }

    public boolean isEmpty() {
        return this.getPlayerManager().isEmpty();
    }

    public int getMaxPlayer() {
        return this.getPlayerManager().getMaxPlayer();
    }

    public void update() {
        this.playerManager.getPlayerList(this.playerBuffer);
        try {
            this.updatePlayers();
            this.notifyUpdatedHandlers();
        }
        finally {
            this.playerBuffer.clear();
        }
    }

    protected void updatePlayers() {
        for (MMOPlayer player : this.playerBuffer) {
            player.clearNearByPlayers();
        }
        for (int i = 0; i < this.playerBuffer.size(); ++i) {
            MMOPlayer player;
            player = this.playerBuffer.get(i);
            for (int k = i; k < this.playerBuffer.size(); ++k) {
                MMOPlayer other = this.playerBuffer.get(k);
                double distance = player.getPosition().distance(other.getPosition());
                if (!(distance <= this.distanceOfInterest)) continue;
                player.addNearbyPlayer(other);
                other.addNearbyPlayer(player);
            }
        }
    }

    protected void notifyUpdatedHandlers() {
        for (MMORoomUpdatedHandler handler : this.roomUpdatedHandlers) {
            handler.onRoomUpdated(this, this.playerBuffer);
        }
    }

    public MMOPlayer getMaster() {
        return this.master;
    }

    public void setMaster(MMOPlayer master) {
        this.master = master;
    }

    public double getDistanceOfInterest() {
        return this.distanceOfInterest;
    }

    public static class Builder
    extends NormalRoom.Builder<Builder> {
        protected int maxPlayer = 999;
        protected double distanceOfInterest;
        protected List<MMORoomUpdatedHandler> roomUpdatedHandlers = new ArrayList<MMORoomUpdatedHandler>();

        public Builder addRoomUpdatedHandler(MMORoomUpdatedHandler handler) {
            this.roomUpdatedHandlers.add(handler);
            return this;
        }

        public Builder distanceOfInterest(double distance) {
            this.distanceOfInterest = distance;
            return this;
        }

        public Builder maxPlayer(int maxPlayer) {
            this.maxPlayer = maxPlayer;
            return this;
        }

        @Override
        public Builder defaultPlayerManager(int maxPlayer) {
            this.playerManager = new SynchronizedPlayerManager(maxPlayer);
            return this;
        }

        @Override
        public Builder playerManager(PlayerManager playerManager) {
            if (playerManager instanceof SynchronizedPlayerManager) {
                return (Builder)super.playerManager(playerManager);
            }
            throw new IllegalArgumentException("playerManager must be SynchronizedPlayerManager");
        }

        @Override
        protected void preBuild() {
            if (this.playerManager == null) {
                this.playerManager = new SynchronizedPlayerManager(this.maxPlayer);
            }
            if (this.distanceOfInterest <= 0.0) {
                throw new IllegalArgumentException("distanceOfInterest must be set!");
            }
            super.preBuild();
        }

        @Override
        public MMORoom build() {
            return (MMORoom)super.build();
        }

        @Override
        protected MMORoom newProduct() {
            return new MMORoom(this);
        }
    }
}

