/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.io;

import com.tvd12.ezyhttp.core.data.BytesRange;
import com.tvd12.ezyhttp.core.io.AnywayFileLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class BytesRangeFileInputStream
extends InputStream {
    private final long from;
    private final long to;
    private final long fileLength;
    private long readBytes;
    private final long targetReadBytes;
    private final RandomAccessFile randomAccessFile;
    public static final int MAX_CHUNK_LENGTH = 0x200000;

    public BytesRangeFileInputStream(String filePath, String range) throws Exception {
        this(filePath, new BytesRange(range));
    }

    public BytesRangeFileInputStream(String filePath, BytesRange range) throws Exception {
        this(filePath, range.getFrom(), range.getTo());
    }

    public BytesRangeFileInputStream(String filePath, long rangeFrom, long rangeTo) throws Exception {
        long actualTo;
        this.from = rangeFrom;
        AnywayFileLoader fileLoader = AnywayFileLoader.getDefault();
        File file = fileLoader.load(filePath);
        if (file == null) {
            throw new FileNotFoundException(filePath + " not found");
        }
        this.fileLength = file.length();
        long l = actualTo = rangeTo == 0L ? this.from + 0x200000L : rangeTo + 1L;
        if (actualTo > this.fileLength) {
            actualTo = this.fileLength;
        }
        this.to = actualTo;
        this.targetReadBytes = actualTo - this.from;
        this.randomAccessFile = new RandomAccessFile(file, "r");
        try {
            this.randomAccessFile.seek(this.from);
        }
        catch (Exception e) {
            this.randomAccessFile.close();
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.readBytes >= this.targetReadBytes) {
            return -1;
        }
        int length = (int)(this.to - (this.from + this.readBytes));
        int actualLength = Math.min(b.length, length);
        int rb = this.randomAccessFile.read(b, 0, actualLength);
        if (rb > 0) {
            this.readBytes += (long)rb;
        }
        return rb;
    }

    @Override
    public int read() throws IOException {
        if (this.readBytes >= this.targetReadBytes) {
            return -1;
        }
        int b = this.randomAccessFile.read();
        if (b >= 0) {
            ++this.readBytes;
        }
        return b;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    public String getBytesContentRangeString() {
        return "bytes " + this.from + '-' + (this.from < this.to ? this.to - 1L : this.to) + '/' + this.fileLength;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getTargetReadBytes() {
        return this.targetReadBytes;
    }
}

