/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.util;

public final class FileSizes {
    private FileSizes() {
    }

    public static long toByteSize(String value) {
        String lowercase = value.toLowerCase();
        if (value.length() > 2) {
            if (lowercase.endsWith("kb")) {
                return FileSizes.subSizeStringToLong(value, 2) * 1024L;
            }
            if (lowercase.endsWith("mb")) {
                return FileSizes.subSizeStringToLong(value, 2) * 1024L * 1024L;
            }
            if (lowercase.endsWith("gb")) {
                return FileSizes.subSizeStringToLong(value, 2) * 1024L * 1024L * 1024L;
            }
            if (lowercase.endsWith("tb")) {
                return FileSizes.subSizeStringToLong(value, 2) * 1024L * 1024L * 1024L * 1024L;
            }
        }
        if (value.length() > 1 && lowercase.endsWith("b")) {
            return FileSizes.subSizeStringToLong(value, 1);
        }
        throw new IllegalArgumentException("size must follow template: [value][B|KB|MB|GB|TB]");
    }

    private static long subSizeStringToLong(String value, int suffixSize) {
        try {
            return Long.parseLong(value.substring(0, value.length() - suffixSize));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("size must follow template: [value][B|KB|MB|GB|TB]", e);
        }
    }
}

