/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import com.tvd12.ezyfox.collect.Lists;
import com.tvd12.ezyfox.io.EzyPrimitiveTypes;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class EzyDataConverter {
    private EzyDataConverter() {
    }

    public static char stringToChar(String value) {
        if (value == null || value.length() == 0) {
            return '\u0000';
        }
        return value.charAt(0);
    }

    public static char[] byteArrayToCharArray(byte[] value) {
        char[] result = new char[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = (char)value[i];
        }
        return result;
    }

    public static byte[] charArrayToByteArray(char[] value) {
        byte[] result = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = (byte)value[i];
        }
        return result;
    }

    public static Boolean[] collectionToWrapperBoolArray(Collection<Boolean> value) {
        return value.toArray(new Boolean[0]);
    }

    public static Byte[] collectionToWrapperByteArray(Collection<? extends Number> value) {
        Byte[] array = new Byte[value.size()];
        int index = 0;
        for (Number number : value) {
            array[index++] = number.byteValue();
        }
        return array;
    }

    public static Character[] collectionToWrapperCharArray(Collection<Character> value) {
        return value.toArray(new Character[0]);
    }

    public static Double[] collectionToWrapperDoubleArray(Collection<? extends Number> value) {
        Double[] array = new Double[value.size()];
        int index = 0;
        for (Number number : value) {
            array[index++] = number.doubleValue();
        }
        return array;
    }

    public static Float[] collectionToWrapperFloatArray(Collection<? extends Number> value) {
        Float[] array = new Float[value.size()];
        int index = 0;
        for (Number number : value) {
            array[index++] = Float.valueOf(number.floatValue());
        }
        return array;
    }

    public static Integer[] collectionToWrapperIntArray(Collection<? extends Number> value) {
        Integer[] array = new Integer[value.size()];
        int index = 0;
        for (Number number : value) {
            array[index++] = number.intValue();
        }
        return array;
    }

    public static Long[] collectionToWrapperLongArray(Collection<? extends Number> value) {
        Long[] array = new Long[value.size()];
        int index = 0;
        for (Number number : value) {
            array[index++] = number.longValue();
        }
        return array;
    }

    public static Short[] collectionToWrapperShortArray(Collection<? extends Number> value) {
        Short[] array = new Short[value.size()];
        int index = 0;
        for (Number number : value) {
            array[index++] = number.shortValue();
        }
        return array;
    }

    public static boolean[] collectionToPrimitiveBoolArray(Collection<Boolean> value) {
        int count = 0;
        boolean[] answer = new boolean[value.size()];
        for (Boolean item : value) {
            answer[count++] = item;
        }
        return answer;
    }

    public static byte[] collectionToPrimitiveByteArray(Collection<? extends Number> value) {
        int count = 0;
        byte[] answer = new byte[value.size()];
        for (Number number : value) {
            answer[count++] = number.byteValue();
        }
        return answer;
    }

    public static char[] collectionToPrimitiveCharArray(Collection<Character> value) {
        int count = 0;
        char[] answer = new char[value.size()];
        for (Character item : value) {
            answer[count++] = item.charValue();
        }
        return answer;
    }

    public static byte[] charCollectionToPrimitiveByteArray(Collection<Character> value) {
        int count = 0;
        byte[] answer = new byte[value.size()];
        for (Character item : value) {
            answer[count++] = (byte)item.charValue();
        }
        return answer;
    }

    public static double[] collectionToPrimitiveDoubleArray(Collection<? extends Number> value) {
        int count = 0;
        double[] answer = new double[value.size()];
        for (Number number : value) {
            answer[count++] = number.doubleValue();
        }
        return answer;
    }

    public static float[] collectionToPrimitiveFloatArray(Collection<? extends Number> value) {
        int count = 0;
        float[] answer = new float[value.size()];
        for (Number number : value) {
            answer[count++] = number.floatValue();
        }
        return answer;
    }

    public static int[] collectionToPrimitiveIntArray(Collection<? extends Number> value) {
        int count = 0;
        int[] answer = new int[value.size()];
        for (Number number : value) {
            answer[count++] = number.intValue();
        }
        return answer;
    }

    public static long[] collectionToPrimitiveLongArray(Collection<? extends Number> value) {
        int count = 0;
        long[] answer = new long[value.size()];
        for (Number number : value) {
            answer[count++] = number.longValue();
        }
        return answer;
    }

    public static short[] collectionToPrimitiveShortArray(Collection<? extends Number> value) {
        int count = 0;
        short[] answer = new short[value.size()];
        for (Number number : value) {
            answer[count++] = number.shortValue();
        }
        return answer;
    }

    public static String[] collectionToStringArray(Collection<String> value) {
        return value.toArray(new String[0]);
    }

    public static <T> List<T> arrayToList(Object value) {
        ArrayList<Object> answer = new ArrayList<Object>();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            answer.add(Array.get(value, i));
        }
        return answer;
    }

    public static <T> List<T> arrayToList(T[] value) {
        return Lists.newArrayList(value);
    }

    public static List<Boolean> arrayToList(boolean[] value) {
        ArrayList<Boolean> answer = new ArrayList<Boolean>();
        for (boolean v : value) {
            answer.add(v);
        }
        return answer;
    }

    public static List<Character> arrayToList(char[] value) {
        ArrayList<Character> answer = new ArrayList<Character>();
        for (char v : value) {
            answer.add(Character.valueOf(v));
        }
        return answer;
    }

    public static List<Double> arrayToList(double[] value) {
        ArrayList<Double> answer = new ArrayList<Double>();
        for (double v : value) {
            answer.add(v);
        }
        return answer;
    }

    public static List<Float> arrayToList(float[] value) {
        ArrayList<Float> answer = new ArrayList<Float>();
        for (float v : value) {
            answer.add(Float.valueOf(v));
        }
        return answer;
    }

    public static List<Integer> arrayToList(int[] value) {
        ArrayList<Integer> answer = new ArrayList<Integer>();
        for (int v : value) {
            answer.add(v);
        }
        return answer;
    }

    public static List<Long> arrayToList(long[] value) {
        ArrayList<Long> answer = new ArrayList<Long>();
        for (long v : value) {
            answer.add(v);
        }
        return answer;
    }

    public static List<Short> arrayToList(short[] value) {
        ArrayList<Short> answer = new ArrayList<Short>();
        for (short v : value) {
            answer.add(v);
        }
        return answer;
    }

    public static List<Character> byteArrayToCharList(byte[] value) {
        ArrayList<Character> answer = new ArrayList<Character>();
        for (byte b : value) {
            answer.add(Character.valueOf((char)b));
        }
        return answer;
    }

    public static Boolean[] toBoolWrapperArray(boolean[] value) {
        Boolean[] answer = new Boolean[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i];
        }
        return answer;
    }

    public static Byte[] toByteWrapperArray(byte[] value) {
        Byte[] answer = new Byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i];
        }
        return answer;
    }

    public static Character[] toCharWrapperArray(byte[] value) {
        Character[] answer = new Character[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = Character.valueOf((char)value[i]);
        }
        return answer;
    }

    public static byte[] toPrimitiveByteArray(Byte[] value) {
        byte[] answer = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i];
        }
        return answer;
    }

    public static char[] toPrimitiveCharArray(Character[] value) {
        char[] answer = new char[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i].charValue();
        }
        return answer;
    }

    public static byte[] charWrapperArrayToPrimitiveByteArray(Character[] value) {
        return EzyDataConverter.charArrayToByteArray(EzyDataConverter.toPrimitiveCharArray(value));
    }

    public static Collection<Boolean> primitiveArrayToBoolCollection(boolean[] value) {
        return EzyPrimitiveTypes.toList(value);
    }

    public static Collection<Byte> primitiveArrayToByteCollection(byte[] value) {
        return EzyPrimitiveTypes.toList(value);
    }

    public static Collection<Character> primitiveArrayToCharCollection(char[] value) {
        return EzyPrimitiveTypes.toList(value);
    }

    public static Collection<Double> primitiveArrayToDoubleCollection(double[] value) {
        return EzyPrimitiveTypes.toList(value);
    }

    public static Collection<Float> primitiveArrayToFloatCollection(float[] value) {
        return EzyPrimitiveTypes.toList(value);
    }

    public static Collection<Integer> primitiveArrayToIntCollection(int[] value) {
        return EzyPrimitiveTypes.toList(value);
    }

    public static Collection<Long> primitiveArrayToLongCollection(long[] value) {
        return EzyPrimitiveTypes.toList(value);
    }

    public static Collection<Short> primitiveArrayToShortCollection(short[] value) {
        return EzyPrimitiveTypes.toList(value);
    }

    public static Collection<String> stringArrayToCollection(String[] value) {
        return Arrays.asList(value);
    }

    public static <T> Collection<T> wrapperArrayToCollection(T[] value) {
        return Arrays.asList(value);
    }

    public static <T> Collection<T> wrapperArrayToCollection(Object value) {
        return Arrays.asList((Object[])value);
    }
}

