/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import com.tvd12.ezyfox.function.EzyNewArray;
import com.tvd12.ezyfox.function.EzyNumber;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public final class EzyNumbersConverter {
    private EzyNumbersConverter() {
    }

    public static byte[] numbersToPrimitiveBytes(Collection coll) {
        int index = 0;
        byte[] answer = new byte[coll.size()];
        for (Object obj : coll) {
            answer[index++] = ((Number)obj).byteValue();
        }
        return answer;
    }

    public static char[] numbersToPrimitiveChars(Collection coll) {
        int index = 0;
        char[] answer = new char[coll.size()];
        for (Object obj : coll) {
            answer[index++] = EzyNumbersConverter.objectToChar(obj).charValue();
        }
        return answer;
    }

    public static double[] numbersToPrimitiveDoubles(Collection coll) {
        int index = 0;
        double[] answer = new double[coll.size()];
        for (Object obj : coll) {
            answer[index++] = ((Number)obj).doubleValue();
        }
        return answer;
    }

    public static float[] numbersToPrimitiveFloats(Collection coll) {
        int index = 0;
        float[] answer = new float[coll.size()];
        for (Object obj : coll) {
            answer[index++] = ((Number)obj).floatValue();
        }
        return answer;
    }

    public static int[] numbersToPrimitiveInts(Collection coll) {
        int index = 0;
        int[] answer = new int[coll.size()];
        for (Object obj : coll) {
            answer[index++] = ((Number)obj).intValue();
        }
        return answer;
    }

    public static long[] numbersToPrimitiveLongs(Collection coll) {
        int index = 0;
        long[] answer = new long[coll.size()];
        for (Object obj : coll) {
            answer[index++] = ((Number)obj).longValue();
        }
        return answer;
    }

    public static short[] numbersToPrimitiveShorts(Collection coll) {
        int index = 0;
        short[] answer = new short[coll.size()];
        for (Object obj : coll) {
            answer[index++] = ((Number)obj).shortValue();
        }
        return answer;
    }

    public static <I, O> O[] objectsToWrapperNumbers(Collection<I> coll, EzyNewArray<O> newer, Function<I, O> mapper) {
        return coll.stream().map(mapper).toArray(newer::apply);
    }

    public static <O> O[] numbersToWrapperNumbers(Collection<? extends Number> coll, EzyNewArray<O> applier, EzyNumber<O> converter) {
        return EzyNumbersConverter.objectsToWrapperNumbers(coll, applier, (I num) -> EzyNumbersConverter.convertNumber(num, converter));
    }

    public static <I, O> O[] objectsToWrapperNumbers(I[] array, EzyNewArray<O> newer, Function<I, O> mapper) {
        return Arrays.stream(array).map(mapper).toArray(newer::apply);
    }

    public static <O> O[] numbersToWrapperNumbers(Number[] numbers, EzyNewArray<O> applier, EzyNumber<O> converter) {
        return EzyNumbersConverter.objectsToWrapperNumbers(numbers, applier, (I num) -> EzyNumbersConverter.convertNumber(num, converter));
    }

    public static Byte[] numbersToWrapperBytes(Collection<? extends Number> coll) {
        return (Byte[])EzyNumbersConverter.numbersToWrapperNumbers(coll, Byte[]::new, EzyNumbersConverter::numberToByte);
    }

    public static Character[] numbersToWrapperChars(Collection coll) {
        int index = 0;
        Character[] answer = new Character[coll.size()];
        for (Object obj : coll) {
            answer[index++] = EzyNumbersConverter.objectToChar(obj);
        }
        return answer;
    }

    public static Double[] numbersToWrapperDoubles(Collection<? extends Number> coll) {
        return (Double[])EzyNumbersConverter.numbersToWrapperNumbers(coll, Double[]::new, EzyNumbersConverter::numberToDouble);
    }

    public static Float[] numbersToWrapperFloats(Collection<? extends Number> coll) {
        return (Float[])EzyNumbersConverter.numbersToWrapperNumbers(coll, Float[]::new, EzyNumbersConverter::numberToFloat);
    }

    public static Integer[] numbersToWrapperInts(Collection<? extends Number> coll) {
        return (Integer[])EzyNumbersConverter.numbersToWrapperNumbers(coll, Integer[]::new, EzyNumbersConverter::numberToInt);
    }

    public static Long[] numbersToWrapperLongs(Collection<? extends Number> coll) {
        return (Long[])EzyNumbersConverter.numbersToWrapperNumbers(coll, Long[]::new, EzyNumbersConverter::numberToLong);
    }

    public static Short[] numbersToWrapperShorts(Collection<? extends Number> coll) {
        return (Short[])EzyNumbersConverter.numbersToWrapperNumbers(coll, Short[]::new, EzyNumbersConverter::numberToShort);
    }

    public static Byte[] numbersToWrapperBytes(Number[] array) {
        return (Byte[])EzyNumbersConverter.numbersToWrapperNumbers(array, Byte[]::new, EzyNumbersConverter::numberToByte);
    }

    public static Character[] numbersToWrapperChars(Object[] value) {
        Character[] answer = new Character[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.objectToChar(value[i]);
        }
        return answer;
    }

    public static Double[] numbersToWrapperDoubles(Number[] array) {
        return (Double[])EzyNumbersConverter.numbersToWrapperNumbers(array, Double[]::new, EzyNumbersConverter::numberToDouble);
    }

    public static Float[] numbersToWrapperFloats(Number[] array) {
        return (Float[])EzyNumbersConverter.numbersToWrapperNumbers(array, Float[]::new, EzyNumbersConverter::numberToFloat);
    }

    public static Integer[] numbersToWrapperInts(Number[] array) {
        return (Integer[])EzyNumbersConverter.numbersToWrapperNumbers(array, Integer[]::new, EzyNumbersConverter::numberToInt);
    }

    public static Long[] numbersToWrapperLongs(Number[] array) {
        return (Long[])EzyNumbersConverter.numbersToWrapperNumbers(array, Long[]::new, EzyNumbersConverter::numberToLong);
    }

    public static Short[] numbersToWrapperShorts(Number[] array) {
        return (Short[])EzyNumbersConverter.numbersToWrapperNumbers(array, Short[]::new, EzyNumbersConverter::numberToShort);
    }

    public static Byte numberToByte(Number number) {
        return (Byte)EzyNumbersConverter.convertNumber(number, Number::byteValue);
    }

    public static Character numberToChar(Number number) {
        return (Character)EzyNumbersConverter.convertNumber(number, num -> Character.valueOf((char)num.byteValue()));
    }

    public static Character objectToChar(Object object) {
        return object instanceof Number ? EzyNumbersConverter.numberToChar((Number)object) : (Character)object;
    }

    public static Double numberToDouble(Number number) {
        return (Double)EzyNumbersConverter.convertNumber(number, Number::doubleValue);
    }

    public static Float numberToFloat(Number number) {
        return (Float)EzyNumbersConverter.convertNumber(number, Number::floatValue);
    }

    public static Integer numberToInt(Number number) {
        return (Integer)EzyNumbersConverter.convertNumber(number, Number::intValue);
    }

    public static Long numberToLong(Number number) {
        return (Long)EzyNumbersConverter.convertNumber(number, Number::longValue);
    }

    public static Short numberToShort(Number number) {
        return (Short)EzyNumbersConverter.convertNumber(number, Number::shortValue);
    }

    public static <T> T convertNumber(Object number, EzyNumber<T> converter) {
        return (T)converter.apply((Number)number);
    }

    public static <T> T convertNumber(Number number, EzyNumber<T> converter) {
        return (T)converter.apply(number);
    }

    public static boolean[] boolArrayWrapperToPrimitive(Boolean[] value) {
        boolean[] answer = new boolean[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i];
        }
        return answer;
    }

    public static byte[] numbersToPrimitiveBytes(Number[] value) {
        byte[] answer = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i].byteValue();
        }
        return answer;
    }

    public static char[] numbersToPrimitiveChars(Object[] value) {
        char[] answer = new char[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.objectToChar(value[i]).charValue();
        }
        return answer;
    }

    public static double[] numbersToPrimitiveDoubles(Number[] value) {
        double[] answer = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i].doubleValue();
        }
        return answer;
    }

    public static float[] numbersToPrimitiveFloats(Number[] value) {
        float[] answer = new float[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i].floatValue();
        }
        return answer;
    }

    public static int[] numbersToPrimitiveInts(Number[] value) {
        int[] answer = new int[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i].intValue();
        }
        return answer;
    }

    public static long[] numbersToPrimitiveLongs(Number[] value) {
        long[] answer = new long[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i].longValue();
        }
        return answer;
    }

    public static short[] numbersToPrimitiveShorts(Number[] value) {
        short[] answer = new short[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i].shortValue();
        }
        return answer;
    }

    public static Boolean[] boolArrayPrimitiveToWrapper(boolean[] value) {
        Boolean[] answer = new Boolean[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i];
        }
        return answer;
    }

    public static Byte[] byteArrayPrimitiveToWrapper(byte[] value) {
        Byte[] answer = new Byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i];
        }
        return answer;
    }

    public static Character[] charArrayPrimitiveToWrapper(char[] value) {
        Character[] answer = new Character[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = Character.valueOf(value[i]);
        }
        return answer;
    }

    public static Double[] doubleArrayPrimitiveToWrapper(double[] value) {
        Double[] answer = new Double[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i];
        }
        return answer;
    }

    public static Float[] floatArrayPrimitiveToWrapper(float[] value) {
        Float[] answer = new Float[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = Float.valueOf(value[i]);
        }
        return answer;
    }

    public static Integer[] intArrayPrimitiveToWrapper(int[] value) {
        Integer[] answer = new Integer[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i];
        }
        return answer;
    }

    public static Long[] longArrayPrimitiveToWrapper(long[] value) {
        Long[] answer = new Long[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i];
        }
        return answer;
    }

    public static Short[] shortArrayPrimitiveToWrapper(short[] value) {
        Short[] answer = new Short[value.length];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = value[i];
        }
        return answer;
    }

    public static boolean[][] boolArraysWrapperToPrimitive(Boolean[][] value) {
        boolean[][] answer = new boolean[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.boolArrayWrapperToPrimitive(value[i]);
        }
        return answer;
    }

    public static byte[][] numbersToPrimitiveByteArrays(Number[][] value) {
        byte[][] answer = new byte[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToPrimitiveBytes(value[i]);
        }
        return answer;
    }

    public static char[][] numbersToPrimitiveCharArrays(Object[][] value) {
        char[][] answer = new char[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToPrimitiveChars(value[i]);
        }
        return answer;
    }

    public static double[][] numbersToPrimitiveDoubleArrays(Number[][] value) {
        double[][] answer = new double[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToPrimitiveDoubles(value[i]);
        }
        return answer;
    }

    public static float[][] numbersToPrimitiveFloatArrays(Number[][] value) {
        float[][] answer = new float[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToPrimitiveFloats(value[i]);
        }
        return answer;
    }

    public static int[][] numbersToPrimitiveIntArrays(Number[][] value) {
        int[][] answer = new int[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToPrimitiveInts(value[i]);
        }
        return answer;
    }

    public static long[][] numbersToPrimitiveLongArrays(Number[][] value) {
        long[][] answer = new long[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToPrimitiveLongs(value[i]);
        }
        return answer;
    }

    public static short[][] numbersToPrimitiveShortArrays(Number[][] value) {
        short[][] answer = new short[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToPrimitiveShorts(value[i]);
        }
        return answer;
    }

    public static Boolean[][] boolArraysPrimitiveToWrapper(boolean[][] value) {
        Boolean[][] answer = new Boolean[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.boolArrayPrimitiveToWrapper(value[i]);
        }
        return answer;
    }

    public static Byte[][] byteArraysPrimitiveToWrapper(byte[][] value) {
        Byte[][] answer = new Byte[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.byteArrayPrimitiveToWrapper(value[i]);
        }
        return answer;
    }

    public static Character[][] charArraysPrimitiveToWrapper(char[][] value) {
        Character[][] answer = new Character[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.charArrayPrimitiveToWrapper(value[i]);
        }
        return answer;
    }

    public static Double[][] doubleArraysPrimitiveToWrapper(double[][] value) {
        Double[][] answer = new Double[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.doubleArrayPrimitiveToWrapper(value[i]);
        }
        return answer;
    }

    public static Float[][] floatArraysPrimitiveToWrapper(float[][] value) {
        Float[][] answer = new Float[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.floatArrayPrimitiveToWrapper(value[i]);
        }
        return answer;
    }

    public static Integer[][] intArraysPrimitiveToWrapper(int[][] value) {
        Integer[][] answer = new Integer[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.intArrayPrimitiveToWrapper(value[i]);
        }
        return answer;
    }

    public static Long[][] longArraysPrimitiveToWrapper(long[][] value) {
        Long[][] answer = new Long[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.longArrayPrimitiveToWrapper(value[i]);
        }
        return answer;
    }

    public static Short[][] shortArraysPrimitiveToWrapper(short[][] value) {
        Short[][] answer = new Short[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.shortArrayPrimitiveToWrapper(value[i]);
        }
        return answer;
    }

    public static Byte[][] numbersToWrapperByteArrays(Number[][] value) {
        Byte[][] answer = new Byte[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToWrapperBytes(value[i]);
        }
        return answer;
    }

    public static Character[][] numbersToWrapperCharArrays(Object[][] value) {
        Character[][] answer = new Character[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToWrapperChars(value[i]);
        }
        return answer;
    }

    public static Double[][] numbersToWrapperDoubleArrays(Number[][] value) {
        Double[][] answer = new Double[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToWrapperDoubles(value[i]);
        }
        return answer;
    }

    public static Float[][] numbersToWrapperFloatArrays(Number[][] value) {
        Float[][] answer = new Float[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToWrapperFloats(value[i]);
        }
        return answer;
    }

    public static Integer[][] numbersToWrapperIntArrays(Number[][] value) {
        Integer[][] answer = new Integer[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToWrapperInts(value[i]);
        }
        return answer;
    }

    public static Long[][] numbersToWrapperLongArrays(Number[][] value) {
        Long[][] answer = new Long[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToWrapperLongs(value[i]);
        }
        return answer;
    }

    public static Short[][] numbersToWrapperShortArrays(Number[][] value) {
        Short[][] answer = new Short[value.length][];
        for (int i = 0; i < value.length; ++i) {
            answer[i] = EzyNumbersConverter.numbersToWrapperShorts(value[i]);
        }
        return answer;
    }
}

