/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import com.tvd12.ezyfox.naming.EzyNamingCase;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class EzyStrings {
    public static final String NULL = "null";
    public static final String UTF_8 = "UTF-8";
    public static final String EMPTY_STRING = "";
    public static final String SPACE = " ";

    private EzyStrings() {
    }

    public static String newUtf(byte[] bytes) {
        return EzyStrings.newString(bytes, UTF_8);
    }

    public static String newUtf(ByteBuffer buffer, int size) {
        return EzyStrings.newString(buffer, size, UTF_8);
    }

    public static byte[] getUtfBytes(String str) {
        return EzyStrings.getBytes(str, UTF_8);
    }

    public static String newString(byte[] bytes, String charset) {
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String newString(ByteBuffer buffer, int size, String charset) {
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return EzyStrings.newString(bytes, charset);
    }

    public static String newString(char ch, int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(ch);
        }
        return builder.toString();
    }

    public static byte[] getBytes(String str, String charset) {
        try {
            return str.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getString(String[] array, int index, String def) {
        return array.length > index ? array[index] : def;
    }

    public static String quote(Object value) {
        return "\"" + (value != null ? value.toString() : NULL) + "\"";
    }

    public static String wrap(Collection collection, String open, String close, String separator, boolean noWrapIfNull) {
        if (collection == null) {
            if (noWrapIfNull) {
                return NULL;
            }
            return open + close;
        }
        int size = collection.size();
        StringBuilder builder = new StringBuilder(open);
        int index = 0;
        for (Object item : collection) {
            builder.append(item);
            if (++index >= size) continue;
            builder.append(separator);
        }
        return builder.append(close).toString();
    }

    public static boolean isEmpty(CharSequence value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence value) {
        return !EzyStrings.isEmpty(value);
    }

    public static boolean isBlank(String value) {
        return EzyStrings.isNoContent(value);
    }

    public static boolean isNoContent(String value) {
        return value == null || value.isEmpty() || value.trim().isEmpty();
    }

    public static boolean isNotBlank(String value) {
        return !EzyStrings.isNoContent(value);
    }

    public static boolean isEqualsIgnoreCase(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (Objects.equals(a, b)) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length() != b.length()) {
            return false;
        }
        int length = a.length();
        for (int i = 0; i < length; ++i) {
            char bchar;
            char achar = a.charAt(i);
            if (achar == (bchar = b.charAt(i)) || EzyStrings.isWordSeparator(achar) && EzyStrings.isWordSeparator(bchar)) continue;
            return false;
        }
        return true;
    }

    public static String join(double[] array, String separator) {
        return Arrays.stream(array).mapToObj(String::valueOf).collect(Collectors.joining(separator));
    }

    public static String join(int[] array, String separator) {
        return Arrays.stream(array).mapToObj(String::valueOf).collect(Collectors.joining(separator));
    }

    public static String join(long[] array, String separator) {
        return Arrays.stream(array).mapToObj(String::valueOf).collect(Collectors.joining(separator));
    }

    public static <T> String join(T[] array, String separator) {
        return EzyStrings.join(Arrays.stream(array), separator);
    }

    public static <T> String join(Collection<T> collection, String separator) {
        return EzyStrings.join(collection.stream(), separator);
    }

    public static <T> String join(Stream<T> stream, String separator) {
        return stream.map(Object::toString).collect(Collectors.joining(separator));
    }

    public static String toUpperCase(String original) {
        return original.toUpperCase();
    }

    public static String toLowerCase(String original) {
        return original.toLowerCase();
    }

    public static String toCamelCase(String original) {
        if (original.length() < 2) {
            return original.toLowerCase();
        }
        return original.substring(0, 1).toLowerCase() + original.substring(1);
    }

    public static String underscoreToCamelCase(String original) {
        if (original == null) {
            return null;
        }
        String trim = original.trim();
        if (trim.length() == 0) {
            return trim;
        }
        if (trim.length() == 1) {
            return trim.toLowerCase();
        }
        StringBuilder builder = new StringBuilder().append(Character.toLowerCase(trim.charAt(0)));
        boolean needUpper = false;
        for (int i = 1; i < trim.length(); ++i) {
            char ch = original.charAt(i);
            if (ch == '_') {
                needUpper = true;
                continue;
            }
            builder.append(needUpper ? Character.toUpperCase(ch) : ch);
            needUpper = false;
        }
        return builder.toString();
    }

    public static String toDotCase(String original) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            char ch = original.charAt(i);
            if (Character.isUpperCase(ch) && i > 0) {
                builder.append(EzyNamingCase.DOT.getSign());
            }
            builder.append(Character.toLowerCase(ch));
        }
        return builder.toString().replace(SPACE, EMPTY_STRING).replace(EzyNamingCase.DASH.getSign(), EzyNamingCase.DOT.getSign()).replace(EzyNamingCase.UNDERSCORE.getSign(), EzyNamingCase.DOT.getSign()).replace(EzyNamingCase.DOT.getSign() + EzyNamingCase.DOT.getSign(), EzyNamingCase.DOT.getSign());
    }

    public static String toDashCase(String original) {
        return EzyStrings.toDotCase(original).replace(EzyNamingCase.DOT.getSign(), EzyNamingCase.DASH.getSign());
    }

    public static String toUnderscoreCase(String original) {
        return EzyStrings.toDotCase(original).replace(EzyNamingCase.DOT.getSign(), EzyNamingCase.UNDERSCORE.getSign());
    }

    public static String toDisplayName(String orignal) {
        if (orignal == null) {
            return EMPTY_STRING;
        }
        int length = orignal.length();
        StringBuilder builder = new StringBuilder();
        block0: for (int i = 0; i < length; ++i) {
            char ch = orignal.charAt(i);
            if (EzyStrings.isWordSeparator(ch)) {
                while (++i < length) {
                    ch = orignal.charAt(i);
                    if (EzyStrings.isWordSeparator(ch)) continue;
                    if (builder.length() > 0) {
                        builder.append(' ');
                    }
                    builder.append(Character.toUpperCase(ch));
                    continue block0;
                }
                continue;
            }
            builder.append(i == 0 ? Character.toUpperCase(ch) : ch);
        }
        return builder.toString();
    }

    public static boolean isWordSeparator(char ch) {
        return ch == '-' || ch == '.' || ch == '_' || ch == ';' || ch == ',' || ch == ' ' || ch == '\t';
    }

    public static String replace(String query, Object[] parameters) {
        return EzyStrings.replace(query, parameters, null);
    }

    public static String replace(String query, Object[] parameters, Function<Object, Object> parameterConverter) {
        int paramCount = parameters.length;
        int length = query.length();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            char ch = query.charAt(i++);
            if (i < length && ch == '?') {
                int numberCharCount = 0;
                int startParamIndex = i;
                ch = query.charAt(i);
                while (ch >= '0' && ch <= '9') {
                    ++numberCharCount;
                    if (++i >= length) break;
                    ch = query.charAt(i);
                }
                if (numberCharCount > 0) {
                    char[] numberChars = new char[numberCharCount];
                    int endParamIndex = startParamIndex + numberCharCount;
                    query.getChars(startParamIndex, endParamIndex, numberChars, 0);
                    int paramIndex = Integer.parseInt(new String(numberChars));
                    if (paramIndex >= paramCount) {
                        throw new IllegalArgumentException("invalid query: " + query + ", not enough parameter values, required: " + paramIndex);
                    }
                    builder.append(EzyStrings.getParameterValue(parameters[paramIndex], parameterConverter));
                    continue;
                }
                builder.append('?');
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    private static Object getParameterValue(Object parameter, Function<Object, Object> parameterConverter) {
        Object value = parameter;
        if (parameterConverter != null) {
            value = parameterConverter.apply(parameter);
        }
        return value;
    }

    /*
     * Exception decompiling
     */
    public static String traceStackToString(Throwable throwable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String exceptionsToString(List<? extends Throwable> exceptions) {
        StringBuilder builder = new StringBuilder();
        for (Throwable throwable : exceptions) {
            builder.append(EzyStrings.traceStackToString(throwable));
        }
        return builder.toString();
    }

    public static String exceptionToSimpleString(Throwable exception) {
        if (exception == null) {
            return EMPTY_STRING;
        }
        return exception.getClass().getName() + ": " + exception.getMessage();
    }

    public static List<String> splitString(String str) {
        ArrayList<String> answer = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (EzyStrings.isWordSeparator(ch)) {
                if (buffer.length() == 0) continue;
                answer.add(buffer.toString());
                buffer.delete(0, buffer.length());
                continue;
            }
            buffer.append(ch);
        }
        if (buffer.length() > 0) {
            answer.add(buffer.toString());
        }
        return answer;
    }
}

