/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver;

import com.tvd12.ezyfoxserver.EzyStarter;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.setting.EzySettingsDecorator;

public abstract class EzyRunner {
    protected EzyServerContext serverContext;

    public void run(String[] args) throws Exception {
        this.validateArguments(args);
        this.startSystem(args);
    }

    protected void validateArguments(String[] args) {
        if (args.length == 0) {
            throw new IllegalStateException("must specific config.properties file");
        }
    }

    protected void startSystem(String[] args) throws Exception {
        String configFile = args.length > 0 ? args[0] : null;
        EzyStarter starter = this.newStarter(configFile);
        starter.start();
        this.serverContext = starter.getServerContext();
    }

    protected EzyStarter newStarter(String configFile) {
        return (EzyStarter)((EzyStarter.Builder)this.newStarterBuilder().configFile(configFile)).settingsDecorator(this.newSettingsDecorator()).build();
    }

    protected abstract EzyStarter.Builder<?> newStarterBuilder();

    protected EzySettingsDecorator newSettingsDecorator() {
        return null;
    }

    public EzyServerContext getServerContext() {
        return this.serverContext;
    }
}

