/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver;

import com.tvd12.ezyfoxserver.EzyAppsStarter;
import com.tvd12.ezyfoxserver.EzyComponentsStater;
import com.tvd12.ezyfoxserver.EzyPluginsStarter;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.EzyZoneComponentsStater;
import com.tvd12.ezyfoxserver.constant.EzyEventType;
import com.tvd12.ezyfoxserver.context.EzyZoneContext;
import com.tvd12.ezyfoxserver.event.EzySimpleServerInitializingEvent;
import java.util.Map;
import java.util.Set;

public class EzyZonesStarter
extends EzyComponentsStater {
    protected EzyZonesStarter(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void start() {
        this.startAllZones();
    }

    protected void startAllZones() {
        Set<String> zoneNames = this.getZoneNames();
        this.logger.info("start zones: {}", zoneNames);
        for (String zoneName : zoneNames) {
            this.startZone(zoneName);
        }
    }

    protected void startZone(String zoneName) {
        EzyZoneContext zoneContext = this.serverContext.getZoneContext(zoneName);
        this.notifyServerInitializing(zoneContext);
        this.startAllPlugins(zoneContext);
        this.startAllApps(zoneContext);
    }

    protected void notifyServerInitializing(EzyZoneContext zoneContext) {
        EzySimpleServerInitializingEvent event = new EzySimpleServerInitializingEvent();
        zoneContext.handleEvent(EzyEventType.SERVER_INITIALIZING, event);
    }

    protected void startAllPlugins(EzyZoneContext zoneContext) {
        this.logger.info("start all plugins ...");
        this.startComponents(this.newPluginsStarterBuilder(), zoneContext);
    }

    protected EzyPluginsStarter.Builder newPluginsStarterBuilder() {
        return EzyPluginsStarter.builder();
    }

    protected void startAllApps(EzyZoneContext zoneContext) {
        this.logger.info("start all apps ...");
        EzyServer server = this.serverContext.getServer();
        EzyAppsStarter.Builder appsStarterBuilder = this.newAppsStarterBuilder().classLoader(server.getClassLoader()).appClassLoaders(this.getAppClassLoaders()).enableAppClassLoader(server.getConfig().isEnableAppClassLoader());
        this.startComponents(appsStarterBuilder, zoneContext);
    }

    protected EzyAppsStarter.Builder newAppsStarterBuilder() {
        return EzyAppsStarter.builder();
    }

    protected void startComponents(EzyZoneComponentsStater.Builder<?, ?> builder, EzyZoneContext zoneContext) {
        EzyZoneComponentsStater starter = this.newComponentsStater(builder, zoneContext);
        starter.start();
    }

    protected EzyZoneComponentsStater newComponentsStater(EzyZoneComponentsStater.Builder<?, ?> builder, EzyZoneContext zoneContext) {
        return (EzyZoneComponentsStater)((Object)builder.zoneContext(zoneContext).build());
    }

    protected Set<String> getZoneNames() {
        return this.settings.getZoneNames();
    }

    protected Map<String, ClassLoader> getAppClassLoaders() {
        return this.serverContext.getServer().getAppClassLoaders();
    }

    public static class Builder
    extends EzyComponentsStater.Builder<EzyZonesStarter, Builder> {
        public EzyZonesStarter build() {
            return new EzyZonesStarter(this);
        }
    }
}

