/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.context;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.EzyComponent;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.command.EzyBroadcastEvent;
import com.tvd12.ezyfoxserver.command.EzyCloseSession;
import com.tvd12.ezyfoxserver.command.EzySendResponse;
import com.tvd12.ezyfoxserver.command.EzyShutdown;
import com.tvd12.ezyfoxserver.command.EzyStreamBytes;
import com.tvd12.ezyfoxserver.command.impl.EzyBroadcastEventImpl;
import com.tvd12.ezyfoxserver.command.impl.EzyCloseSessionImpl;
import com.tvd12.ezyfoxserver.command.impl.EzySendResponseImpl;
import com.tvd12.ezyfoxserver.command.impl.EzyServerShutdownImpl;
import com.tvd12.ezyfoxserver.command.impl.EzyStreamBytesImpl;
import com.tvd12.ezyfoxserver.constant.EzyTransportType;
import com.tvd12.ezyfoxserver.context.EzyAbstractComplexContext;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.context.EzyZoneContext;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.event.EzyEvent;
import com.tvd12.ezyfoxserver.exception.EzyZoneNotFoundException;
import com.tvd12.ezyfoxserver.response.EzyResponse;
import com.tvd12.ezyfoxserver.setting.EzyZoneSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EzySimpleServerContext
extends EzyAbstractComplexContext
implements EzyServerContext {
    protected EzyServer server;
    protected EzyStreamBytes streamBytes;
    protected EzySendResponse sendResponse;
    protected EzyBroadcastEvent broadcastEvent;
    protected final List<EzyZoneContext> zoneContexts = new ArrayList<EzyZoneContext>();
    protected final Map<Integer, EzyZoneContext> zoneContextsById = new ConcurrentHashMap<Integer, EzyZoneContext>();
    protected final Map<String, EzyZoneContext> zoneContextsByName = new ConcurrentHashMap<String, EzyZoneContext>();

    @Override
    protected void doInit() {
        this.broadcastEvent = new EzyBroadcastEventImpl(this);
        this.streamBytes = new EzyStreamBytesImpl(this.server);
        this.sendResponse = new EzySendResponseImpl(this.server);
        this.properties.put(EzyBroadcastEvent.class, this.broadcastEvent);
        this.properties.put(EzyStreamBytes.class, this.streamBytes);
        this.properties.put(EzySendResponse.class, this.sendResponse);
        this.properties.put(EzyShutdown.class, new EzyServerShutdownImpl(this));
        this.properties.put(EzyCloseSession.class, new EzyCloseSessionImpl(this));
    }

    @Override
    protected <T> T parentGet(Class<T> clazz) {
        throw new IllegalArgumentException("has no instance of " + clazz);
    }

    @Override
    protected <T> T parentCmd(Class<T> clazz) {
        throw new IllegalArgumentException("has no command of " + clazz);
    }

    @Override
    public void broadcast(EzyConstant eventType, EzyEvent event, boolean catchException) {
        this.broadcastEvent.fire(eventType, event, catchException);
    }

    @Override
    public void send(EzyResponse response, EzySession recipient, boolean encrypted, EzyTransportType transportType) {
        this.sendResponse.execute(response, recipient, encrypted, false, transportType);
    }

    @Override
    public void send(EzyResponse response, Collection<EzySession> recipients, boolean encrypted, EzyTransportType transportType) {
        this.sendResponse.execute(response, recipients, encrypted, false, transportType);
    }

    @Override
    public void sendNow(EzyResponse response, EzySession recipient) {
        this.sendResponse.execute(response, recipient, false, true, EzyTransportType.TCP);
    }

    @Override
    public void stream(byte[] bytes, EzySession recipient, EzyTransportType transportType) {
        this.streamBytes.execute(bytes, recipient, transportType);
    }

    @Override
    public void stream(byte[] bytes, Collection<EzySession> recipients, EzyTransportType transportType) {
        this.streamBytes.execute(bytes, recipients, transportType);
    }

    public void addZoneContexts(Collection<EzyZoneContext> zoneContexts) {
        for (EzyZoneContext ctx : zoneContexts) {
            this.addZoneContext(ctx.getZone().getSetting(), ctx);
        }
    }

    public void addZoneContext(EzyZoneSetting zone, EzyZoneContext zoneContext) {
        this.zoneContexts.add(zoneContext);
        this.zoneContextsById.put(zone.getId(), zoneContext);
        this.zoneContextsByName.put(zone.getName(), zoneContext);
        this.addAppContexts(zoneContext.getAppContexts());
        this.addPluginContexts(zoneContext.getPluginContexts());
    }

    @Override
    public EzyZoneContext getZoneContext(int zoneId) {
        EzyZoneContext zoneContext = this.zoneContextsById.get(zoneId);
        if (zoneContext != null) {
            return zoneContext;
        }
        throw new EzyZoneNotFoundException(zoneId);
    }

    @Override
    public EzyZoneContext getZoneContext(String zoneName) {
        EzyZoneContext zoneContext = this.zoneContextsByName.get(zoneName);
        if (zoneContext != null) {
            return zoneContext;
        }
        throw new EzyZoneNotFoundException(zoneName);
    }

    public void setServer(EzyServer server) {
        this.server = server;
        this.component = (EzyComponent)((Object)server);
    }

    @Override
    protected void destroyComponents() {
        this.destroyZoneContexts();
        this.destroyServer();
    }

    @Override
    protected void clearProperties() {
        super.clearProperties();
        this.server = null;
        this.sendResponse = null;
        this.broadcastEvent = null;
        this.zoneContexts.clear();
        this.zoneContextsById.clear();
        this.zoneContextsByName.clear();
    }

    private void destroyServer() {
        EzyProcessor.processWithLogException(() -> ((EzyDestroyable)this.server).destroy());
    }

    private void destroyZoneContexts() {
        for (EzyZoneContext zc : this.zoneContextsById.values()) {
            this.destroyZoneContext(zc);
        }
    }

    private void destroyZoneContext(EzyZoneContext zoneContext) {
        EzyProcessor.processWithLogException(() -> ((EzyDestroyable)((EzyDestroyable)zoneContext)).destroy());
    }

    @Override
    protected void preDestroy() {
        this.logger.debug("destroy ServerContext ...");
    }

    @Override
    protected void postDestroy() {
        this.logger.debug("ServerContext has destroyed");
    }

    @Override
    public EzyServer getServer() {
        return this.server;
    }

    @Override
    public List<EzyZoneContext> getZoneContexts() {
        return this.zoneContexts;
    }
}

