/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.setting;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyEquals;
import com.tvd12.ezyfox.util.EzyHashCodes;
import com.tvd12.ezyfoxserver.setting.EzyBaseSetting;
import com.tvd12.ezyfoxserver.setting.EzyHomePathAware;
import com.tvd12.ezyfoxserver.setting.EzyZoneIdAware;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class EzyAbstractSetting
implements EzyBaseSetting,
EzyZoneIdAware,
EzyHomePathAware {
    protected final int id = this.newId();
    @XmlElement(name="name")
    protected String name;
    @XmlElement(name="folder")
    protected String folder;
    @XmlElement(name="active-profiles")
    protected String activeProfiles;
    @XmlElement(name="package-name")
    protected String packageName;
    protected int zoneId;
    @XmlElement(name="entry-loader")
    protected String entryLoader;
    @XmlElement(name="thread-pool-size")
    protected int threadPoolSize = 0;
    @XmlElement(name="config-file")
    protected String configFile = "config.properties";
    protected String homePath = "";
    protected Object[] entryLoaderArgs;

    protected int newId() {
        return this.getIdCounter().incrementAndGet();
    }

    public void setEntryLoader(Class<?> loaderClass) {
        this.entryLoader = loaderClass.getName();
    }

    public void setEntryLoader(String loaderClass) {
        this.entryLoader = loaderClass;
    }

    public void setEntryLoaderArgs(Object[] args) {
        this.entryLoaderArgs = args;
    }

    @Override
    public String getFolder() {
        return EzyStrings.isNoContent((String)this.folder) ? this.name : this.folder;
    }

    @Override
    public String getLocation() {
        return Paths.get(this.homePath, this.getParentFolder(), this.getFolder()).toString();
    }

    @Override
    public String getConfigFile() {
        return this.getConfigFile(false);
    }

    @Override
    public String getConfigFile(boolean noParent) {
        if (noParent) {
            return this.configFile;
        }
        return Paths.get(this.getLocation(), this.configFile).toString();
    }

    @Override
    public String getConfigFileInput() {
        return this.getConfigFile(true);
    }

    protected abstract String getParentFolder();

    protected abstract AtomicInteger getIdCounter();

    public boolean equals(Object obj) {
        return new EzyEquals().function(t -> t.id).isEquals((Object)this, obj);
    }

    public int hashCode() {
        return new EzyHashCodes().append((Object)this.id).toHashCode();
    }

    public Map<Object, Object> toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("id", this.id);
        map.put("name", this.name);
        map.put("folder", this.getFolder());
        map.put("packageName", this.packageName);
        map.put("activeProfiles", this.activeProfiles);
        map.put("entryLoader", this.entryLoader);
        map.put("threadPoolSize", this.threadPoolSize);
        map.put("configFile", this.configFile != null ? this.configFile : "");
        return map;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getActiveProfiles() {
        return this.activeProfiles;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public int getZoneId() {
        return this.zoneId;
    }

    @Override
    public String getEntryLoader() {
        return this.entryLoader;
    }

    @Override
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public String getHomePath() {
        return this.homePath;
    }

    @Override
    public Object[] getEntryLoaderArgs() {
        return this.entryLoaderArgs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public void setActiveProfiles(String activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void setZoneId(int zoneId) {
        this.zoneId = zoneId;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public void setHomePath(String homePath) {
        this.homePath = homePath;
    }
}

