/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.socket;

import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.socket.EzySocketStream;
import com.tvd12.ezyfoxserver.socket.EzySocketStreamQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public class EzyBlockingSocketStreamQueue
extends EzyLoggable
implements EzySocketStreamQueue {
    private final int capacity;
    private final BlockingQueue<EzySocketStream> queue;

    public EzyBlockingSocketStreamQueue() {
        this(50000);
    }

    public EzyBlockingSocketStreamQueue(int capacity) {
        this.capacity = capacity;
        this.queue = this.newQueue(capacity);
    }

    protected BlockingQueue<EzySocketStream> newQueue(int capacity) {
        return new LinkedBlockingDeque<EzySocketStream>(capacity);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean isFull() {
        return this.queue.size() >= this.capacity;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean add(EzySocketStream stream) {
        if (this.queue.size() >= this.capacity) {
            return false;
        }
        return this.queue.offer(stream);
    }

    @Override
    public void remove(EzySocketStream stream) {
        this.queue.remove(stream);
    }

    @Override
    public EzySocketStream take() throws InterruptedException {
        return this.queue.take();
    }
}

