/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.statistics;

import com.tvd12.ezyfox.io.EzyDates;
import java.io.Serializable;

public abstract class EzyRequestFrame
implements Serializable {
    private static final long serialVersionUID = 5034914725676324216L;
    protected final long endTime;
    protected final long startTime;
    protected final int maxRequests;
    protected volatile int requests;

    public EzyRequestFrame(int maxRequests) {
        this(maxRequests, System.currentTimeMillis());
    }

    public EzyRequestFrame(int maxRequests, long startTime) {
        this.maxRequests = maxRequests;
        this.startTime = startTime;
        this.endTime = startTime + this.getExistsTime();
    }

    protected abstract long getExistsTime();

    public boolean addRequests(long requests) {
        this.requests = (int)((long)this.requests + requests);
        return this.requests > this.maxRequests;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.endTime;
    }

    public boolean isInvalid() {
        return this.requests > this.maxRequests;
    }

    public abstract EzyRequestFrame nextFrame();

    public String toString() {
        return this.getClass().getSimpleName() + ": " + EzyDates.format((long)this.startTime) + " -> " + EzyDates.format((long)this.endTime);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public int getRequests() {
        return this.requests;
    }
}

