/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.handler;

import com.tvd12.ezyfox.concurrent.callback.EzyResultCallback;
import com.tvd12.ezyfox.exception.EzyFileNotFoundException;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.stream.EzyAnywayInputStreamLoader;
import com.tvd12.ezyfox.stream.EzyInputStreamLoader;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyhttp.core.constant.ContentEncoding;
import com.tvd12.ezyhttp.core.constant.ContentType;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import com.tvd12.ezyhttp.core.io.BytesRangeFileInputStream;
import com.tvd12.ezyhttp.core.resources.ActualContentTypeDetector;
import com.tvd12.ezyhttp.core.resources.ResourceDownloadManager;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.handler.RequestHandler;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ResourceRequestHandler
implements RequestHandler {
    private final String resourcePath;
    private final String resourceURI;
    private final String resourceExtension;
    private final EzyInputStreamLoader inputStreamLoader;
    private final ResourceDownloadManager downloadManager;
    private final int defaultTimeout;
    private final ActualContentTypeDetector actualContentTypeDetector = ActualContentTypeDetector.getInstance();

    public ResourceRequestHandler(String resourcePath, String resourceURI, String resourceExtension, ResourceDownloadManager downloadManager) {
        this(resourcePath, resourceURI, resourceExtension, downloadManager, 0);
    }

    public ResourceRequestHandler(String resourcePath, String resourceURI, String resourceExtension, EzyInputStreamLoader inputStreamLoader, ResourceDownloadManager downloadManager) {
        this(resourcePath, resourceURI, resourceExtension, inputStreamLoader, downloadManager, 0);
    }

    public ResourceRequestHandler(String resourcePath, String resourceURI, String resourceExtension, ResourceDownloadManager downloadManager, int defaultTimeout) {
        this(resourcePath, resourceURI, resourceExtension, (EzyInputStreamLoader)new EzyAnywayInputStreamLoader(), downloadManager, defaultTimeout);
    }

    @Override
    public Object handle(RequestArguments arguments) throws Exception {
        AsyncContext asyncContext = arguments.getAsyncContext();
        try {
            return this.doHandle(asyncContext, arguments);
        }
        catch (Throwable e) {
            EzyProcessor.processWithLogException(() -> ((AsyncContext)asyncContext).complete());
            if (e instanceof FileNotFoundException || e instanceof EzyFileNotFoundException) {
                throw new HttpNotFoundException((Object)e);
            }
            throw e;
        }
    }

    protected Object doHandle(final AsyncContext asyncContext, RequestArguments arguments) throws Exception {
        InputStream inputStream;
        if (this.defaultTimeout > 0) {
            asyncContext.setTimeout((long)this.defaultTimeout);
        }
        final HttpServletResponse servletResponse = (HttpServletResponse)asyncContext.getResponse();
        String contentType = this.getResponseContentType();
        String actualContentType = this.actualContentTypeDetector.detect(this.resourcePath, contentType);
        servletResponse.setContentType(actualContentType);
        ContentEncoding contentEncoding = ContentEncoding.ofMimeType((String)contentType);
        if (contentEncoding != null) {
            servletResponse.setHeader("Content-Encoding", contentEncoding.getValue());
        }
        int statusCode = 200;
        String range = arguments.getHeader("Range");
        if (EzyStrings.isBlank((String)range)) {
            inputStream = this.inputStreamLoader.load(this.resourcePath);
            if (inputStream == null) {
                throw new FileNotFoundException(this.resourcePath + " file not found");
            }
        } else {
            BytesRangeFileInputStream is = new BytesRangeFileInputStream(this.resourcePath, range);
            servletResponse.setHeader("accept-ranges", "bytes");
            servletResponse.setHeader("Content-Range", is.getBytesContentRangeString());
            servletResponse.setHeader("Content-Length", String.valueOf(is.getTargetReadBytes()));
            statusCode = 206;
            servletResponse.setStatus(statusCode);
            inputStream = is;
        }
        final int statusCodeFinal = statusCode;
        ServletOutputStream outputStream = servletResponse.getOutputStream();
        try {
            this.downloadManager.drainAsync(inputStream, (OutputStream)outputStream, (EzyResultCallback)new EzyResultCallback<Boolean>(){

                public void onResponse(Boolean response) {
                    EzyProcessor.processWithLogException(inputStream::close);
                    servletResponse.setStatus(statusCodeFinal);
                    asyncContext.complete();
                }

                public void onException(Exception e) {
                    EzyProcessor.processWithLogException(inputStream::close);
                    servletResponse.setStatus(500);
                    asyncContext.complete();
                }
            });
        }
        catch (Exception e) {
            EzyProcessor.processWithLogException(inputStream::close);
            servletResponse.setStatus(500);
            asyncContext.complete();
        }
        return ResponseEntity.ASYNC;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.GET;
    }

    @Override
    public String getRequestURI() {
        return this.resourceURI;
    }

    @Override
    public String getResponseContentType() {
        return ContentType.ofExtension((String)this.resourceExtension).getValue();
    }

    public ResourceRequestHandler(String resourcePath, String resourceURI, String resourceExtension, EzyInputStreamLoader inputStreamLoader, ResourceDownloadManager downloadManager, int defaultTimeout) {
        this.resourcePath = resourcePath;
        this.resourceURI = resourceURI;
        this.resourceExtension = resourceExtension;
        this.inputStreamLoader = inputStreamLoader;
        this.downloadManager = downloadManager;
        this.defaultTimeout = defaultTimeout;
    }
}

