/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyhttp.core.codec.DataConverters;
import com.tvd12.ezyhttp.core.json.ObjectMapperBuilder;
import com.tvd12.ezyhttp.server.core.handler.RequestResponseWatcher;
import com.tvd12.ezyhttp.server.core.handler.UnhandledErrorHandler;
import com.tvd12.ezyhttp.server.core.manager.ControllerManager;
import com.tvd12.ezyhttp.server.core.manager.ExceptionHandlerManager;
import com.tvd12.ezyhttp.server.core.manager.InterceptorManager;
import com.tvd12.ezyhttp.server.core.manager.RequestHandlerManager;
import com.tvd12.ezyhttp.server.core.view.ViewContext;
import java.util.ArrayList;
import java.util.List;

public final class ComponentManager
implements EzyDestroyable {
    private boolean debug;
    private int serverPort;
    private int managementPort;
    private boolean exposeManagementURIs;
    private int asyncDefaultTimeout;
    private ViewContext viewContext;
    private final ObjectMapper objectMapper = new ObjectMapperBuilder().build();
    private final DataConverters dataConverters = new DataConverters(this.objectMapper);
    private UnhandledErrorHandler unhandledErrorHandler;
    private final ControllerManager controllerManager;
    private final InterceptorManager interceptorManager;
    private final RequestHandlerManager requestHandlerManager;
    private final ExceptionHandlerManager exceptionHandlerManager;
    private final List<RequestResponseWatcher> requestResponseWatchers = new ArrayList<RequestResponseWatcher>();
    private static final ComponentManager INSTANCE = new ComponentManager();

    private ComponentManager() {
        this.controllerManager = new ControllerManager();
        this.interceptorManager = new InterceptorManager();
        this.requestHandlerManager = new RequestHandlerManager();
        this.exceptionHandlerManager = new ExceptionHandlerManager();
    }

    public static ComponentManager getInstance() {
        return INSTANCE;
    }

    public void setUnhandledErrorHandler(List<UnhandledErrorHandler> handlers) {
        if (!handlers.isEmpty()) {
            this.unhandledErrorHandler = handlers.get(0);
        }
    }

    public void addRequestResponseWatchers(List<RequestResponseWatcher> watchers) {
        this.requestResponseWatchers.addAll(watchers);
    }

    public void destroy() {
        this.viewContext = null;
        this.exposeManagementURIs = false;
        this.unhandledErrorHandler = null;
        this.dataConverters.destroy();
        this.controllerManager.destroy();
        this.interceptorManager.destroy();
        this.requestHandlerManager.destroy();
        this.exceptionHandlerManager.destroy();
        this.requestResponseWatchers.clear();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getManagementPort() {
        return this.managementPort;
    }

    public boolean isExposeManagementURIs() {
        return this.exposeManagementURIs;
    }

    public int getAsyncDefaultTimeout() {
        return this.asyncDefaultTimeout;
    }

    public ViewContext getViewContext() {
        return this.viewContext;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public DataConverters getDataConverters() {
        return this.dataConverters;
    }

    public UnhandledErrorHandler getUnhandledErrorHandler() {
        return this.unhandledErrorHandler;
    }

    public ControllerManager getControllerManager() {
        return this.controllerManager;
    }

    public InterceptorManager getInterceptorManager() {
        return this.interceptorManager;
    }

    public RequestHandlerManager getRequestHandlerManager() {
        return this.requestHandlerManager;
    }

    public ExceptionHandlerManager getExceptionHandlerManager() {
        return this.exceptionHandlerManager;
    }

    public List<RequestResponseWatcher> getRequestResponseWatchers() {
        return this.requestResponseWatchers;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setManagementPort(int managementPort) {
        this.managementPort = managementPort;
    }

    public void setExposeManagementURIs(boolean exposeManagementURIs) {
        this.exposeManagementURIs = exposeManagementURIs;
    }

    public void setAsyncDefaultTimeout(int asyncDefaultTimeout) {
        this.asyncDefaultTimeout = asyncDefaultTimeout;
    }

    public void setViewContext(ViewContext viewContext) {
        this.viewContext = viewContext;
    }
}

