/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.request;

import com.tvd12.ezyfox.builder.EzyBuilder;

public class RequestURIMeta {
    private final boolean api;
    private final boolean authenticated;
    private final boolean authenticatable;
    private final boolean management;
    private final boolean resource;
    private final boolean payment;
    private final String feature;
    private final String resourceFullPath;

    protected RequestURIMeta(Builder builder) {
        this.api = builder.api;
        this.authenticated = builder.authenticated;
        this.authenticatable = builder.authenticatable;
        this.management = builder.management;
        this.resource = builder.resource;
        this.payment = builder.payment;
        this.feature = builder.feature;
        this.resourceFullPath = builder.resourceFullPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isApi() {
        return this.api;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isAuthenticatable() {
        return this.authenticatable;
    }

    public boolean isManagement() {
        return this.management;
    }

    public boolean isResource() {
        return this.resource;
    }

    public boolean isPayment() {
        return this.payment;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getResourceFullPath() {
        return this.resourceFullPath;
    }

    public static class Builder
    implements EzyBuilder<RequestURIMeta> {
        private boolean api;
        private boolean authenticated;
        private boolean authenticatable;
        private boolean management;
        private boolean resource;
        private boolean payment;
        private String feature;
        private String resourceFullPath;

        public Builder api(boolean api) {
            this.api = api;
            return this;
        }

        public Builder authenticated(boolean authenticated) {
            this.authenticated = authenticated;
            return this;
        }

        public Builder authenticatable(boolean authenticatable) {
            this.authenticatable = authenticatable;
            return this;
        }

        public Builder management(boolean management) {
            this.management = management;
            return this;
        }

        public Builder resource(boolean resource) {
            this.resource = resource;
            return this;
        }

        public Builder payment(boolean payment) {
            this.payment = payment;
            return this;
        }

        public Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public Builder resourceFullPath(String resourceFullPath) {
            this.resourceFullPath = resourceFullPath;
            return this;
        }

        public RequestURIMeta build() {
            return new RequestURIMeta(this);
        }
    }
}

