/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.database.query;

import com.tvd12.ezydata.database.query.EzyQueryCondition;
import com.tvd12.ezydata.database.query.EzyQueryConditionChain;
import com.tvd12.ezydata.database.query.EzyQueryConditionGroup;
import com.tvd12.ezydata.database.query.EzyQueryMethodType;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.util.Next;
import java.util.ArrayList;
import java.util.List;

public class EzyQueryMethod {
    protected final EzyMethod method;
    protected final EzyQueryMethodType type;
    protected final EzyQueryConditionChain conditionChain;
    protected static final String OR = "Or";
    protected static final String AND = "And";

    public EzyQueryMethod(EzyMethod method) {
        this.method = method;
        this.type = EzyQueryMethod.getType(method);
        this.conditionChain = EzyQueryMethod.getConditionChain(method);
        this.postConstruct();
    }

    private static EzyQueryMethodType getType(EzyMethod method) {
        EzyQueryMethodType answer = EzyQueryMethodType.FIND;
        String methodName = method.getName();
        for (EzyQueryMethodType it : EzyQueryMethodType.values()) {
            if (!methodName.startsWith(it.getPrefix())) continue;
            answer = it;
        }
        return answer;
    }

    private static EzyQueryConditionChain getConditionChain(EzyMethod method) {
        String methodName = method.getName();
        String chain = "";
        if (methodName.startsWith("countBy")) {
            chain = methodName.substring("countBy".length());
        } else if (methodName.startsWith("findBy")) {
            chain = methodName.substring("findBy".length());
        } else if (methodName.startsWith("deleteBy")) {
            chain = methodName.substring("deleteBy".length());
        }
        EzyQueryConditionChain.Builder conditionChainBuilder = EzyQueryConditionChain.builder();
        if (chain.isEmpty()) {
            return conditionChainBuilder.build();
        }
        List<String> conditionGroupStrings = EzyQueryMethod.splitConditions(chain, OR);
        for (String conditionGroupString : conditionGroupStrings) {
            List<String> conditionStrings = EzyQueryMethod.splitConditions(conditionGroupString, AND);
            EzyQueryConditionGroup.Builder conditionGroupBuilder = EzyQueryConditionGroup.builder();
            for (String conditionString : conditionStrings) {
                conditionGroupBuilder.addCondition(EzyQueryCondition.parse(conditionString));
            }
            conditionChainBuilder.addConditionGroup(conditionGroupBuilder.build());
        }
        return conditionChainBuilder.build();
    }

    public static List<String> splitConditions(String chain, String operator) {
        int afterIndex;
        int index;
        int fromIndex = 0;
        String remaining = chain;
        ArrayList<String> conditions = new ArrayList<String>();
        while ((index = remaining.indexOf(operator, fromIndex)) > 0 && (afterIndex = index + operator.length()) < remaining.length()) {
            char afterOperatorChar = remaining.charAt(afterIndex);
            if (Character.isUpperCase(afterOperatorChar)) {
                conditions.add(remaining.substring(0, index));
                fromIndex = 0;
                remaining = remaining.substring(afterIndex);
                continue;
            }
            fromIndex = afterIndex;
        }
        conditions.add(remaining);
        return conditions;
    }

    public static int getQueryParameterCount(EzyMethod method) {
        if (EzyQueryMethod.isPaginationMethod(method)) {
            return method.getParameterCount() - 1;
        }
        return method.getParameterCount();
    }

    public static boolean isPaginationMethod(EzyMethod method) {
        int paramCount = method.getParameterCount();
        if (paramCount > 0) {
            Class lastParamType = method.getParameterTypes()[paramCount - 1];
            return Next.class.isAssignableFrom(lastParamType);
        }
        return false;
    }

    protected void postConstruct() {
        int actualCount;
        int requiredCount = this.conditionChain.getParameterCount();
        if (requiredCount != (actualCount = EzyQueryMethod.getQueryParameterCount(this.method))) {
            throw new IllegalArgumentException("invalid query method: " + this.method + " not enough parameter (expected: " + requiredCount + ", actual: " + actualCount + ")");
        }
    }

    public EzyMethod getMethod() {
        return this.method;
    }

    public EzyQueryMethodType getType() {
        return this.type;
    }

    public EzyQueryConditionChain getConditionChain() {
        return this.conditionChain;
    }
}

