/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyFileUtil;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.client.concurrent.DownloadCancellationToken;
import com.tvd12.ezyhttp.client.concurrent.UploadCancellationToken;
import com.tvd12.ezyhttp.client.data.DownloadFileResult;
import com.tvd12.ezyhttp.client.exception.DownloadCancelledException;
import com.tvd12.ezyhttp.client.exception.UploadCancelledException;
import com.tvd12.ezyhttp.client.request.DownloadRequest;
import com.tvd12.ezyhttp.client.request.Request;
import com.tvd12.ezyhttp.client.request.RequestEntity;
import com.tvd12.ezyhttp.client.request.UploadRequest;
import com.tvd12.ezyhttp.core.codec.BodyDeserializer;
import com.tvd12.ezyhttp.core.codec.BodySerializer;
import com.tvd12.ezyhttp.core.codec.DataConverters;
import com.tvd12.ezyhttp.core.constant.ContentEncoding;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.data.MultiValueMap;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import com.tvd12.ezyhttp.core.exception.HttpConflictException;
import com.tvd12.ezyhttp.core.exception.HttpForbiddenException;
import com.tvd12.ezyhttp.core.exception.HttpInternalServerErrorException;
import com.tvd12.ezyhttp.core.exception.HttpMethodNotAllowedException;
import com.tvd12.ezyhttp.core.exception.HttpNotAcceptableException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import com.tvd12.ezyhttp.core.exception.HttpPaymentRequiredException;
import com.tvd12.ezyhttp.core.exception.HttpRequestException;
import com.tvd12.ezyhttp.core.exception.HttpRequestTimeoutException;
import com.tvd12.ezyhttp.core.exception.HttpTooManyRequestsException;
import com.tvd12.ezyhttp.core.exception.HttpUnauthorizedException;
import com.tvd12.ezyhttp.core.exception.HttpUnsupportedMediaTypeException;
import com.tvd12.ezyhttp.core.json.ObjectMapperBuilder;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class HttpClient
extends EzyLoggable {
    protected final int defaultReadTimeout;
    protected final int defaultConnectTimeout;
    protected final DataConverters dataConverters;
    public static final int NO_TIMEOUT = -1;

    protected HttpClient(Builder builder) {
        this.defaultReadTimeout = builder.readTimeout;
        this.defaultConnectTimeout = builder.connectTimeout;
        this.dataConverters = builder.dataConverters;
    }

    public <T> T call(Request request) throws Exception {
        ResponseEntity response = this.request(request.getMethod(), request.getURL(), request.getEntity(), request.getResponseTypes(), request.getConnectTimeout(), request.getReadTimeout());
        return this.getResponseBody(response);
    }

    public ResponseEntity request(Request request) throws Exception {
        return this.request(request.getMethod(), request.getURL(), request.getEntity(), request.getResponseTypes(), request.getConnectTimeout(), request.getReadTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity request(HttpMethod method, String url, RequestEntity entity, Map<Integer, Class<?>> responseTypes, int connectTimeout, int readTimeout) throws Exception {
        if (url == null) {
            throw new IllegalArgumentException("url can not be null");
        }
        this.logger.debug("start: {} - {} - {}", new Object[]{method, url, entity != null ? entity.getHeaders() : null});
        HttpURLConnection connection = this.connect(url);
        try {
            MultiValueMap requestHeaders;
            connection.setConnectTimeout(connectTimeout > 0 ? connectTimeout : this.defaultConnectTimeout);
            connection.setReadTimeout(readTimeout > 0 ? readTimeout : this.defaultReadTimeout);
            connection.setRequestMethod(method.toString());
            connection.setDoInput(true);
            connection.setDoOutput(method.hasOutput());
            connection.setInstanceFollowRedirects(method == HttpMethod.GET);
            MultiValueMap multiValueMap = requestHeaders = entity != null ? entity.getHeaders() : null;
            if (requestHeaders != null) {
                Map encodedHeaders = requestHeaders.toMap();
                for (Map.Entry requestHeader : encodedHeaders.entrySet()) {
                    connection.setRequestProperty((String)requestHeader.getKey(), (String)requestHeader.getValue());
                }
            }
            if (connection.getRequestProperty("Accept-Encoding") == null) {
                connection.setRequestProperty("Accept-Encoding", ContentEncoding.GZIP.getValue());
            }
            Object requestBody = null;
            if (method != HttpMethod.GET && entity != null) {
                requestBody = entity.getBody();
            }
            byte[] requestBodyBytes = null;
            if (requestBody != null) {
                String requestContentType = connection.getRequestProperty("Content-Type");
                if (requestContentType == null) {
                    requestContentType = "application/json";
                    connection.setRequestProperty("Content-Type", "application/json");
                }
                requestBodyBytes = this.serializeRequestBody(requestContentType, requestBody);
                int requestContentLength = requestBodyBytes.length;
                connection.setFixedLengthStreamingMode(requestContentLength);
            }
            connection.connect();
            if (requestBodyBytes != null) {
                if (method.hasOutput()) {
                    OutputStream outputStream = connection.getOutputStream();
                    outputStream.write(requestBodyBytes);
                    outputStream.flush();
                    outputStream.close();
                } else {
                    throw new IllegalArgumentException(method + " method can not have a payload body");
                }
            }
            ResponseEntity response = this.processConnectionResponse(connection, responseTypes);
            this.logger.debug("end: {} - {} - {} - {}", new Object[]{method, url, response.getStatus(), response.getHeaders()});
            ResponseEntity responseEntity = response;
            return responseEntity;
        }
        finally {
            connection.disconnect();
        }
    }

    public HttpURLConnection connect(String url) throws Exception {
        URL requestURL = new URL(url);
        return (HttpURLConnection)requestURL.openConnection();
    }

    protected byte[] serializeRequestBody(String contentType, Object requestBody) throws IOException {
        BodySerializer serializer = this.dataConverters.getBodySerializer(contentType);
        return serializer.serialize(requestBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseEntity processConnectionResponse(HttpURLConnection connection, Map<Integer, Class<?>> responseTypes) throws Exception {
        int responseCode = connection.getResponseCode();
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        MultiValueMap responseHeaders = MultiValueMap.of(headerFields);
        String responseContentType = responseHeaders.getValue("Content-Type");
        if (responseContentType == null) {
            responseContentType = "application/json";
        }
        InputStream inputStream = this.decorateInputStream(connection, responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream());
        Object responseBody = null;
        if (inputStream != null) {
            try {
                int responseContentLength = connection.getContentLength();
                Class<?> responseType = responseTypes.get(responseCode);
                responseBody = this.deserializeResponseBody(responseContentType, responseContentLength, inputStream, responseType);
            }
            finally {
                inputStream.close();
            }
        }
        return new ResponseEntity(responseCode, responseHeaders, responseBody);
    }

    protected Object deserializeResponseBody(String contentType, int contentLength, InputStream inputStream, Class<?> responseType) throws IOException {
        Object body;
        BodyDeserializer deserializer = this.dataConverters.getBodyDeserializer(contentType);
        if (responseType != null) {
            body = responseType == String.class ? deserializer.deserializeToString(inputStream, contentLength) : deserializer.deserialize(inputStream, responseType);
        } else {
            body = deserializer.deserializeToString(inputStream, contentLength);
            if (body != null) {
                try {
                    body = deserializer.deserialize((String)body, Map.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return body;
    }

    public <T> T getResponseBody(ResponseEntity entity) throws Exception {
        int statusCode = entity.getStatus();
        Object body = entity.getBody();
        if (statusCode < 400) {
            return (T)body;
        }
        throw this.translateErrorCode(statusCode, body);
    }

    private Exception translateErrorCode(int statusCode, Object body) {
        if (statusCode == 400) {
            return new HttpBadRequestException(body);
        }
        if (statusCode == 404) {
            return new HttpNotFoundException(body);
        }
        if (statusCode == 401) {
            return new HttpUnauthorizedException(body);
        }
        if (statusCode == 402) {
            return new HttpPaymentRequiredException(body);
        }
        if (statusCode == 403) {
            return new HttpForbiddenException(body);
        }
        if (statusCode == 405) {
            return new HttpMethodNotAllowedException(body);
        }
        if (statusCode == 406) {
            return new HttpNotAcceptableException(body);
        }
        if (statusCode == 408) {
            return new HttpRequestTimeoutException(body);
        }
        if (statusCode == 409) {
            return new HttpConflictException(body);
        }
        if (statusCode == 415) {
            return new HttpUnsupportedMediaTypeException(body);
        }
        if (statusCode == 429) {
            return new HttpTooManyRequestsException(body);
        }
        if (statusCode == 500) {
            return new HttpInternalServerErrorException(body);
        }
        return new HttpRequestException(statusCode, body);
    }

    public String download(String fileURL, File storeLocation) throws Exception {
        return this.download(fileURL, storeLocation, DownloadCancellationToken.ALWAYS_RUN);
    }

    public String download(String fileURL, File storeLocation, DownloadCancellationToken cancellationToken) throws Exception {
        return this.download(new DownloadRequest(fileURL), storeLocation, cancellationToken);
    }

    public String download(DownloadRequest request, File storeLocation) throws Exception {
        return this.download(request, storeLocation, DownloadCancellationToken.ALWAYS_RUN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String download(DownloadRequest request, File storeLocation, DownloadCancellationToken cancellationToken) throws Exception {
        String fileURL = request.getFileURL();
        HttpURLConnection connection = this.connect(fileURL);
        try {
            this.decorateDownloadConnection(connection, request);
            connection.connect();
            String string = this.download(connection, fileURL, storeLocation, cancellationToken);
            return string;
        }
        finally {
            connection.disconnect();
        }
    }

    private String download(HttpURLConnection connection, String fileURL, File storeLocation, DownloadCancellationToken cancellationToken) throws Exception {
        int responseCode = connection.getResponseCode();
        if (responseCode >= 400) {
            throw this.processDownloadError(connection, fileURL, responseCode);
        }
        String disposition = connection.getHeaderField("Content-Disposition");
        String fileName = HttpClient.getDownloadFileName(fileURL, disposition);
        Files.createDirectories(storeLocation.toPath(), new FileAttribute[0]);
        File storeFile = Paths.get(storeLocation.toString(), fileName).toFile();
        File downloadingFile = new File(storeFile + ".downloading");
        Path downloadingFilePath = downloadingFile.toPath();
        Files.deleteIfExists(downloadingFilePath);
        Files.createFile(downloadingFilePath, new FileAttribute[0]);
        try (InputStream inputStream = this.decorateInputStream(connection, connection.getInputStream());
             FileOutputStream outputStream = new FileOutputStream(downloadingFile);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                if (cancellationToken.isCancelled()) {
                    break;
                }
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        if (cancellationToken.isCancelled()) {
            Files.deleteIfExists(downloadingFilePath);
            throw new DownloadCancelledException(fileURL);
        }
        Files.move(downloadingFile.toPath(), storeFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return fileName;
    }

    public void download(String fileURL, OutputStream outputStream) throws Exception {
        this.download(fileURL, outputStream, DownloadCancellationToken.ALWAYS_RUN);
    }

    public void download(String fileURL, OutputStream outputStream, DownloadCancellationToken cancellationToken) throws Exception {
        this.download(new DownloadRequest(fileURL), outputStream, cancellationToken);
    }

    public void download(DownloadRequest request, OutputStream outputStream) throws Exception {
        this.download(request, outputStream, DownloadCancellationToken.ALWAYS_RUN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(DownloadRequest request, OutputStream outputStream, DownloadCancellationToken cancellationToken) throws Exception {
        String fileURL = request.getFileURL();
        HttpURLConnection connection = this.connect(fileURL);
        try {
            this.decorateDownloadConnection(connection, request);
            connection.connect();
            this.download(connection, fileURL, outputStream, cancellationToken);
        }
        finally {
            connection.disconnect();
        }
    }

    private void download(HttpURLConnection connection, String fileURL, OutputStream outputStream, DownloadCancellationToken cancellationToken) throws Exception {
        int responseCode = connection.getResponseCode();
        if (responseCode >= 400) {
            throw this.processDownloadError(connection, fileURL, responseCode);
        }
        try (InputStream inputStream = this.decorateInputStream(connection, connection.getInputStream());){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                if (cancellationToken.isCancelled()) {
                    break;
                }
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        if (cancellationToken.isCancelled()) {
            throw new DownloadCancelledException(fileURL);
        }
    }

    public DownloadFileResult download(String fileUrl, File storeLocation, String fileName) throws Exception {
        return this.download(fileUrl, storeLocation, fileName, DownloadCancellationToken.ALWAYS_RUN);
    }

    public DownloadFileResult download(String fileUrl, File storeLocation, String fileName, DownloadCancellationToken cancellationToken) throws Exception {
        return this.download(new DownloadRequest(fileUrl), storeLocation, fileName, cancellationToken);
    }

    public DownloadFileResult download(DownloadRequest request, File storeLocation, String fileName) throws Exception {
        return this.download(request, storeLocation, fileName, DownloadCancellationToken.ALWAYS_RUN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadFileResult download(DownloadRequest request, File storeLocation, String fileName, DownloadCancellationToken cancellationToken) throws Exception {
        String fileURL = request.getFileURL();
        HttpURLConnection connection = this.connect(fileURL);
        try {
            this.decorateDownloadConnection(connection, request);
            connection.connect();
            DownloadFileResult downloadFileResult = this.download(connection, request, storeLocation, fileName, cancellationToken);
            return downloadFileResult;
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadFileResult download(HttpURLConnection originalConnection, DownloadRequest request, File storeLocation, String fileName, DownloadCancellationToken cancellationToken) throws Exception {
        HttpURLConnection connection = originalConnection;
        try {
            String fileURL;
            String newFileURL = fileURL = request.getFileURL();
            while (true) {
                boolean redirect;
                int responseCode;
                if ((responseCode = connection.getResponseCode()) >= 400) {
                    throw this.processDownloadError(connection, newFileURL, responseCode);
                }
                boolean bl = redirect = responseCode == 302 || responseCode == 301 || responseCode == 303;
                if (!redirect) break;
                newFileURL = connection.getHeaderField("Location");
                String cookies = connection.getHeaderField("Set-Cookie");
                connection.disconnect();
                connection = (HttpURLConnection)new URL(newFileURL).openConnection();
                this.decorateDownloadConnection(connection, request);
                if (cookies == null) continue;
                connection.setRequestProperty("Cookie", cookies);
            }
            String disposition = connection.getHeaderField("Content-Disposition");
            String originalFileName = HttpClient.getDownloadFileName(newFileURL, disposition);
            String newFileName = HttpClient.makeDownloadFileName(disposition, newFileURL, fileName);
            File storeFile = storeLocation.toPath().resolve(newFileName).toFile();
            EzyFileUtil.createFileIfNotExists((File)storeFile);
            try (InputStream inputStream = this.decorateInputStream(connection, connection.getInputStream());
                 OutputStream outputStream = Files.newOutputStream(storeFile.toPath(), new OpenOption[0]);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    if (cancellationToken.isCancelled()) {
                        break;
                    }
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            if (cancellationToken.isCancelled()) {
                throw new DownloadCancelledException(fileURL);
            }
            DownloadFileResult downloadFileResult = new DownloadFileResult(originalFileName, newFileName);
            return downloadFileResult;
        }
        finally {
            connection.disconnect();
        }
    }

    private void decorateDownloadConnection(HttpURLConnection connection, DownloadRequest request) {
        this.decorateConnection(connection, request.getConnectTimeout(), request.getReadTimeout(), request.getHeaders());
    }

    private InputStream decorateInputStream(HttpURLConnection connection, InputStream inputStream) throws Exception {
        return this.decorateInputStream(connection.getHeaderField("Content-Encoding"), inputStream);
    }

    private InputStream decorateInputStream(String contentEncoding, InputStream inputStream) throws IOException {
        ContentEncoding contentEncodingEnum = ContentEncoding.ofValue((String)contentEncoding);
        if (contentEncodingEnum == ContentEncoding.GZIP) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception processDownloadError(HttpURLConnection connection, String fileURL, int responseCode) throws Exception {
        InputStream inputStream = this.decorateInputStream(connection, connection.getErrorStream());
        Object responseBody = "";
        if (inputStream != null) {
            try {
                int contentLength = connection.getContentLength();
                responseBody = this.deserializeResponseBody(null, contentLength, inputStream, null);
            }
            finally {
                inputStream.close();
            }
        }
        this.logger.debug("download error: {} - {} - {}", new Object[]{fileURL, responseCode, responseBody});
        return this.translateErrorCode(responseCode, responseBody);
    }

    private static String makeDownloadFileName(String contentDisposition, String fileURL, String fileName) {
        String originalFileName = HttpClient.getDownloadFileName(fileURL, contentDisposition);
        String fileExtension = EzyFileUtil.getFileExtension((String)originalFileName);
        return EzyStrings.isBlank((String)fileExtension) ? fileName : fileName + "." + fileExtension;
    }

    public static String getDownloadFileName(String fileURL, String contentDisposition) {
        String prefix;
        int startIndex;
        String answer = null;
        if (contentDisposition != null && (startIndex = contentDisposition.indexOf(prefix = "filename=")) >= 0) {
            char ch;
            int quoteCount = 0;
            int quotesCount = 0;
            StringBuilder builder = new StringBuilder();
            for (int i = startIndex + prefix.length(); i < contentDisposition.length() && (ch = contentDisposition.charAt(i)) != ';'; ++i) {
                if (ch == '\'') {
                    if (++quoteCount < 2) continue;
                    break;
                }
                if (ch == '\"') {
                    if (++quotesCount < 2) continue;
                    break;
                }
                builder.append(ch);
            }
            answer = builder.toString().trim();
        }
        if (EzyStrings.isBlank(answer)) {
            answer = fileURL.substring(fileURL.lastIndexOf("/") + 1);
        }
        if (answer.contains("?")) {
            answer = answer.substring(0, answer.indexOf(63));
        }
        return answer;
    }

    public <T> T callUpload(UploadRequest request) throws Exception {
        ResponseEntity response = this.upload(request);
        return this.getResponseBody(response);
    }

    public <T> T callUpload(UploadRequest request, UploadCancellationToken cancellationToken) throws Exception {
        ResponseEntity response = this.upload(request, cancellationToken);
        return this.getResponseBody(response);
    }

    public ResponseEntity upload(UploadRequest request) throws Exception {
        return this.upload(request, UploadCancellationToken.ALWAYS_RUN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity upload(UploadRequest request, UploadCancellationToken cancellationToken) throws Exception {
        String filePath = request.getFilePath();
        InputStream requestInputStream = request.getInputStream();
        if (filePath == null && requestInputStream == null) {
            throw new IllegalArgumentException("upload required a file path or in input stream");
        }
        HttpURLConnection connection = this.connect(request.getURL());
        try {
            connection.setDoOutput(true);
            connection.setRequestMethod(request.getMethod().toString());
            this.decorateUploadConnection(connection, request);
            String boundary = Long.toHexString(System.currentTimeMillis());
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            OutputStream outputStream = connection.getOutputStream();
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);
            writer.append("--").append(boundary).append("\r\n");
            String fileName = request.getFileName();
            if (EzyStrings.isBlank((String)fileName)) {
                fileName = filePath != null ? EzyFileUtil.getFileName((String)filePath) : "unknown";
            }
            writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(fileName).append("\"\r\n");
            writer.append("Content-Type: application/octet-stream\r\n\r\n");
            writer.flush();
            InputStream inputStream = requestInputStream;
            if (inputStream == null) {
                inputStream = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
            }
            try {
                int bytesRead;
                byte[] buffer = new byte[1204];
                while ((bytesRead = inputStream.read(buffer)) != -1 && !cancellationToken.isCancelled()) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                if (cancellationToken.isCancelled()) {
                    throw new UploadCancelledException(filePath);
                }
                outputStream.flush();
            }
            finally {
                if (requestInputStream == null) {
                    inputStream.close();
                }
            }
            writer.append("\r\n").append("--").append(boundary).append("--").append("\r\n");
            writer.flush();
            writer.close();
            ResponseEntity responseEntity = this.processConnectionResponse(connection, request.getResponseTypes());
            return responseEntity;
        }
        finally {
            connection.disconnect();
        }
    }

    private void decorateUploadConnection(HttpURLConnection connection, UploadRequest request) {
        this.decorateConnection(connection, request.getConnectTimeout(), request.getReadTimeout(), request.getHeaders());
    }

    private void decorateConnection(HttpURLConnection connection, int connectTimeout, int readTimeout, MultiValueMap requestHeaders) {
        connection.setConnectTimeout(connectTimeout > 0 ? connectTimeout : this.defaultConnectTimeout);
        connection.setReadTimeout(readTimeout > 0 ? readTimeout : this.defaultReadTimeout);
        if (requestHeaders != null) {
            Map encodedHeaders = requestHeaders.toMap();
            for (Map.Entry requestHeader : encodedHeaders.entrySet()) {
                connection.setRequestProperty((String)requestHeader.getKey(), (String)requestHeader.getValue());
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements EzyBuilder<HttpClient> {
        protected int readTimeout = 15000;
        protected int connectTimeout = 15000;
        protected ObjectMapper objectMapper;
        protected Object stringConverter;
        protected DataConverters dataConverters;
        protected final List<Object> bodyConverterList = new ArrayList<Object>();
        protected final Map<String, Object> bodyConverterMap = new HashMap<String, Object>();

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder objectMapper(Object objectMapper) {
            if (objectMapper instanceof ObjectMapper) {
                this.objectMapper = (ObjectMapper)objectMapper;
            }
            return this;
        }

        public Builder setStringConverter(Object converter) {
            this.stringConverter = converter;
            return this;
        }

        public Builder addBodyConverter(Object converter) {
            this.bodyConverterList.add(converter);
            return this;
        }

        public Builder addBodyConverter(String contentType, Object converter) {
            this.bodyConverterMap.put(contentType, converter);
            return this;
        }

        public Builder addBodyConverters(List<?> converters) {
            this.bodyConverterList.addAll(converters);
            return this;
        }

        public Builder addBodyConverters(Map<String, Object> converterByContentType) {
            this.bodyConverterMap.putAll(converterByContentType);
            return this;
        }

        public HttpClient build() {
            if (this.objectMapper == null) {
                this.objectMapper = new ObjectMapperBuilder().build();
            }
            this.dataConverters = new DataConverters(this.objectMapper);
            if (this.stringConverter != null) {
                this.dataConverters.setStringConverter(this.stringConverter);
            }
            this.dataConverters.addBodyConverters(this.bodyConverterList);
            this.dataConverters.addBodyConverters(this.bodyConverterMap);
            return new HttpClient(this);
        }
    }
}

