/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.controller.decorator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.model.NotificationReceiverModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.SimpleNotificationModel;
import org.youngmonkeys.ezyplatform.web.converter.WebModelToResponseConverter;
import org.youngmonkeys.ezyplatform.web.response.NotificationResponse;
import org.youngmonkeys.ezyplatform.web.service.WebNotificationService;

@EzySingleton
public class WebNotificationModelDecorator {
    private final WebNotificationService notificationService;
    private final WebModelToResponseConverter modelToResponseConverter;

    public PaginationModel<NotificationResponse> decorate(PaginationModel<NotificationReceiverModel> pagination) {
        List models = pagination.getItems();
        Set notificationIds = models.stream().map(NotificationReceiverModel::getNotificationId).filter(it -> it > 0L).collect(Collectors.toSet());
        Map notificationById = this.notificationService.getNotificationMapByIds(notificationIds);
        return pagination.map(it -> {
            SimpleNotificationModel notification = notificationById.getOrDefault(it.getNotificationId(), SimpleNotificationModel.builder().build());
            return this.modelToResponseConverter.toResponse(notification, (NotificationReceiverModel)it);
        });
    }

    public WebNotificationModelDecorator(WebNotificationService notificationService, WebModelToResponseConverter modelToResponseConverter) {
        this.notificationService = notificationService;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

