/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.interceptor;

import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.core.annotation.Interceptor;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.interceptor.RequestInterceptor;
import com.tvd12.ezyhttp.server.core.manager.RequestURIManager;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.lang.reflect.Method;

@Interceptor(priority=-2147483648)
public class WebLogInterceptor
extends EzyLoggable
implements RequestInterceptor {
    private final RequestURIManager requestUriManager;

    public boolean preHandle(RequestArguments arguments, Method handler) {
        String uriTemplate = arguments.getUriTemplate();
        HttpMethod method = arguments.getMethod();
        if (!this.requestUriManager.isManagementURI(method, uriTemplate)) {
            this.logger.info("pre handle request uri: {}, method: {}", (Object)arguments.getRequest().getRequestURI(), (Object)arguments.getMethod());
        }
        return true;
    }

    public void postHandle(RequestArguments arguments, Method handler) {
        String uriTemplate = arguments.getUriTemplate();
        HttpMethod method = arguments.getMethod();
        if (!this.requestUriManager.isManagementURI(method, uriTemplate)) {
            this.logger.info("post handle request uri: {}, method: {}, code: {}", new Object[]{arguments.getRequest().getRequestURI(), arguments.getMethod(), arguments.getResponse().getStatus()});
        }
    }

    public WebLogInterceptor(RequestURIManager requestUriManager) {
        this.requestUriManager = requestUriManager;
    }
}

