/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.interceptor;

import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.core.annotation.Interceptor;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.interceptor.RequestInterceptor;
import com.tvd12.ezyhttp.server.core.manager.RequestURIManager;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.lang.reflect.Method;
import java.util.Set;
import org.youngmonkeys.ezyplatform.annotation.AdminAccessToken;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.web.service.WebAdminService;
import org.youngmonkeys.ezyplatform.web.service.WebSettingService;

@Interceptor(priority=-2147483647)
public class WebManagementAuthenticationInterceptor
extends EzyLoggable
implements RequestInterceptor {
    private final WebAdminService adminService;
    private final WebSettingService settingService;
    private final RequestURIManager requestUriManager;

    public boolean preHandle(RequestArguments arguments, Method handler) {
        String uriTemplate;
        HttpMethod method = arguments.getMethod();
        if (this.requestUriManager.isManagementURI(method, uriTemplate = arguments.getUriTemplate())) {
            String accessToken = arguments.getHeader("adminAccessToken");
            if (accessToken == null) {
                accessToken = arguments.getHeader("Adminaccesstoken");
            }
            if (accessToken == null) {
                accessToken = arguments.getHeader("adminaccesstoken");
            }
            if (accessToken == null) {
                accessToken = arguments.getCookieValue("adminAccessToken");
            }
            if (accessToken == null) {
                accessToken = (String)arguments.getArgument((Object)"adminAccessToken");
            }
            arguments.setArgument(AdminAccessToken.class, (Object)accessToken);
            this.validateAccessToken(arguments, uriTemplate, accessToken);
        }
        return true;
    }

    private void validateAccessToken(RequestArguments arguments, String uriTemplate, String accessToken) {
        Set<String> autoPassUris = this.settingService.getAutoPassManagementUris();
        if (autoPassUris.contains("*") || autoPassUris.contains(uriTemplate)) {
            return;
        }
        long adminId = this.adminService.validateAdminAccessToken(accessToken);
        arguments.setArgument(AdminId.class, (Object)adminId);
    }

    public WebManagementAuthenticationInterceptor(WebAdminService adminService, WebSettingService settingService, RequestURIManager requestUriManager) {
        this.adminService = adminService;
        this.settingService = settingService;
        this.requestUriManager = requestUriManager;
    }
}

