/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.validator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import java.util.HashMap;
import org.youngmonkeys.ezyplatform.manager.PasswordManager;
import org.youngmonkeys.ezyplatform.model.LoginFailuresModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;
import org.youngmonkeys.ezyplatform.web.event.ValidateLoginPasswordEvent;
import org.youngmonkeys.ezyplatform.web.event.WebEventHandlerManager;
import org.youngmonkeys.ezyplatform.web.request.LoginRequest;
import org.youngmonkeys.ezyplatform.web.request.RegisterRequest;
import org.youngmonkeys.ezyplatform.web.service.WebUserLoginService;
import org.youngmonkeys.ezyplatform.web.service.WebUserService;

@EzySingleton
public class WebAuthenticationValidator {
    private final WebEventHandlerManager eventHandlerManager;
    private final PasswordManager passwordManager;
    private final WebUserService userService;
    private final WebUserLoginService userLoginService;

    public void validate(RegisterRequest request) {
        String displayName;
        String password;
        String email;
        HashMap<String, String> errors = new HashMap<String, String>();
        String username = request.getUsername();
        if (username != null) {
            if (!DefaultValidator.isValidUsername((String)username)) {
                errors.put("username", "invalid");
            } else if (this.userService.getUserByUsername(username) != null) {
                errors.put("username", "duplicated");
            }
        }
        if ((email = request.getEmail()) != null) {
            if (!DefaultValidator.isValidEmail((String)email)) {
                errors.put("email", "invalid");
            } else if (this.userService.getUserByEmail(email) != null) {
                errors.put("email", "duplicated");
            }
        }
        if (EzyStrings.isBlank((String)(password = request.getPassword()))) {
            errors.put("password", "required");
        } else if (!DefaultValidator.isValidPassword((String)password)) {
            errors.put("password", "invalid");
        }
        String phoneNumber = request.getPhoneNumber();
        if (phoneNumber != null) {
            if (!DefaultValidator.isValidPhone((String)phoneNumber)) {
                errors.put("phoneNumber", "invalid");
            } else if (this.userService.getUserByPhone(phoneNumber) != null) {
                errors.put("phoneNumber", "duplicated");
            }
        }
        if ((displayName = request.getDisplayName()) != null && displayName.length() > 128) {
            errors.put("displayName", "overLength");
        }
        this.eventHandlerManager.handleEvent("validate_user_register", EzyMapBuilder.mapBuilder().put((Object)"request", (Object)request).put((Object)"errors", errors).toMap());
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public UserModel validate(LoginRequest request) {
        UserModel user;
        HashMap<String, Object> errors = new HashMap<String, Object>();
        String username = request.getUsername();
        if (!DefaultValidator.isValidUsername((String)username) && !DefaultValidator.isValidEmail((String)username)) {
            errors.put("username", "invalid");
        }
        if (!DefaultValidator.isValidPassword((String)request.getPassword())) {
            errors.put("password", "invalid");
        }
        if ((user = this.userService.getUserByUsername(request.getUsername())) == null) {
            user = this.userService.getUserByEmail(request.getUsername());
        }
        if (user == null) {
            user = this.userService.getUserByPhone(request.getUsername());
        }
        if (user == null) {
            errors.put("username", "invalid");
        } else {
            long userId = user.getId();
            int blockDuration = this.userLoginService.getBlockingLoginDurationInMinutes(userId);
            if (blockDuration > 0) {
                errors.put("loginBlockDuration", blockDuration);
            }
            this.eventHandlerManager.handleEvent("validate_user_login", EzyMapBuilder.mapBuilder().put((Object)"userId", (Object)userId).put((Object)"user", (Object)user).put((Object)"request", (Object)request).put((Object)"errors", errors).toMap());
            if (errors.isEmpty()) {
                Boolean result;
                String password = request.getPassword();
                boolean isMatching = this.passwordManager.isMatchingPassword(password, user.getPassword());
                if (!isMatching && (result = (Boolean)this.eventHandlerManager.handleEvent(new ValidateLoginPasswordEvent(user.getId(), password))) != null) {
                    isMatching = result;
                }
                if (isMatching) {
                    this.userLoginService.cleanLoginFailures(userId);
                    return user;
                }
                errors.put("password", "incorrect");
                LoginFailuresModel loginFailures = this.userLoginService.increaseLoginFailures(user.getId());
                errors.put("loginFailures", loginFailures.getLoginFailures());
                errors.put("loginBlockDuration", loginFailures.getBlockDuration());
                errors.put("maxLoginFailures", loginFailures.getMaxLoginFailures());
            }
        }
        throw new HttpBadRequestException(errors);
    }

    public WebAuthenticationValidator(WebEventHandlerManager eventHandlerManager, PasswordManager passwordManager, WebUserService userService, WebUserLoginService userLoginService) {
        this.eventHandlerManager = eventHandlerManager;
        this.passwordManager = passwordManager;
        this.userService = userService;
        this.userLoginService = userLoginService;
    }
}

