/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.setting;

import com.tvd12.ezyfoxserver.setting.EzyPluginSetting;
import com.tvd12.ezyfoxserver.setting.EzyPluginsSetting;
import com.tvd12.ezyfoxserver.setting.EzySimplePluginSetting;
import com.tvd12.ezyfoxserver.setting.EzyZoneIdAware;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="plugins")
public class EzySimplePluginsSetting
implements EzyPluginsSetting {
    protected final List<EzyPluginSetting> plugins = new ArrayList<EzyPluginSetting>();
    protected final Map<Integer, EzySimplePluginSetting> pluginsByIds = new ConcurrentHashMap<Integer, EzySimplePluginSetting>();
    protected final Map<String, EzySimplePluginSetting> pluginsByNames = new ConcurrentHashMap<String, EzySimplePluginSetting>();

    @XmlElement(name="plugin")
    public void setItem(EzySimplePluginSetting item) {
        this.plugins.add(item);
        this.pluginsByIds.put(item.getId(), item);
        this.pluginsByNames.put(item.getName(), item);
    }

    @Override
    public Set<String> getPluginNames() {
        return this.pluginsByNames.keySet();
    }

    @Override
    public Set<Integer> getPluginIds() {
        return this.pluginsByIds.keySet();
    }

    @Override
    public EzySimplePluginSetting getPluginByName(String name) {
        EzySimplePluginSetting pluginSetting = this.pluginsByNames.get(name);
        if (pluginSetting != null) {
            return pluginSetting;
        }
        throw new IllegalArgumentException("has no plugin with name: " + name);
    }

    @Override
    public EzySimplePluginSetting getPluginById(Integer id) {
        EzySimplePluginSetting pluginSetting = this.pluginsByIds.get(id);
        if (pluginSetting != null) {
            return pluginSetting;
        }
        throw new IllegalArgumentException("has no plugin with id: " + id);
    }

    @Override
    public int getSize() {
        return this.plugins.size();
    }

    public void setZoneId(int zoneId) {
        this.plugins.forEach(p -> ((EzyZoneIdAware)((Object)p)).setZoneId(zoneId));
    }

    public Map<Object, Object> toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ArrayList<Map> pluginMaps = new ArrayList<Map>();
        for (EzyPluginSetting plugin : this.plugins) {
            pluginMaps.add(plugin.toMap());
        }
        map.put("size", this.plugins.size());
        map.put("plugins", pluginMaps);
        return map;
    }

    @Override
    public List<EzyPluginSetting> getPlugins() {
        return this.plugins;
    }

    public Map<Integer, EzySimplePluginSetting> getPluginsByIds() {
        return this.pluginsByIds;
    }

    public Map<String, EzySimplePluginSetting> getPluginsByNames() {
        return this.pluginsByNames;
    }

    public String toString() {
        return "EzySimplePluginsSetting(plugins=" + this.getPlugins() + ", pluginsByIds=" + this.getPluginsByIds() + ", pluginsByNames=" + this.getPluginsByNames() + ")";
    }
}

