/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.wrapper.impl;

import com.tvd12.ezyfox.concurrent.EzyExecutors;
import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.function.EzyFunctions;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfox.util.EzyStartable;
import com.tvd12.ezyfoxserver.constant.EzyDisconnectReason;
import com.tvd12.ezyfoxserver.delegate.EzyUserDelegate;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.wrapper.EzyAbstractUserManager;
import com.tvd12.ezyfoxserver.wrapper.EzyZoneUserManager;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class EzyZoneUserManagerImpl
extends EzyAbstractUserManager
implements EzyZoneUserManager,
EzyStartable {
    protected final String zoneName;
    protected final EzyUserDelegate userDelegate;
    protected final long idleValidationDelay;
    protected final long idleValidationInterval;
    protected final int idleValidationThreadPoolSize;
    protected final ScheduledExecutorService idleValidationService;
    protected final Map<EzySession, EzyUser> usersBySession = new ConcurrentHashMap<EzySession, EzyUser>();

    protected EzyZoneUserManagerImpl(Builder builder) {
        super(builder);
        this.zoneName = builder.zoneName;
        this.userDelegate = builder.userDelegate;
        this.idleValidationDelay = builder.idleValidationDelay;
        this.idleValidationInterval = builder.idleValidationInterval;
        this.idleValidationThreadPoolSize = builder.idleValidationThreadPoolSize;
        this.idleValidationService = this.newIdleValidationService(builder.maxIdleTime);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected ScheduledExecutorService newIdleValidationService(long maxIdleTime) {
        if (maxIdleTime <= 0L) {
            return null;
        }
        ScheduledExecutorService answer = EzyExecutors.newScheduledThreadPool((int)this.idleValidationThreadPoolSize, (String)"user-manager");
        Runtime.getRuntime().addShutdownHook(new Thread(answer::shutdown));
        return answer;
    }

    @Override
    public void addUser(EzySession session, EzyUser user) {
        this.checkMaxUsers();
        this.usersById.put(user.getId(), user);
        this.usersByName.put(user.getName(), user);
        this.usersBySession.put(session, user);
        this.logger.info("zone: {} add user: {}, locks.size = {}, usersById.size = {}, usersByName.size = {}", new Object[]{this.zoneName, user, this.locks.size(), this.usersById.size(), this.usersByName.size()});
    }

    @Override
    public void bind(EzySession session, EzyUser user) {
        this.usersBySession.put(session, user);
    }

    @Override
    public EzyUser getUser(EzySession session) {
        return this.usersBySession.get(session);
    }

    @Override
    public boolean containsUser(EzySession session) {
        return this.usersBySession.containsKey(session);
    }

    @Override
    public void unmapSessionUser(EzySession session, EzyConstant reason) {
        EzyUser user = this.usersBySession.remove(session);
        if (user != null) {
            user.removeSession(session);
            this.logger.debug("zone: {} remove session {} from user {} by reason {}, user remain: {} sessions, usersBySession.size: {}", new Object[]{this.zoneName, session.getClientAddress(), user, reason, user.getSessionCount(), this.usersBySession.size()});
            if (this.shouldRemoveUserNow(user)) {
                this.removeUser(user, reason);
            }
        }
    }

    protected boolean shouldRemoveUserNow(EzyUser user) {
        int sessionCount = user.getSessionCount();
        long maxIdleTime = user.getMaxIdleTime();
        return sessionCount <= 0 && maxIdleTime <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(EzyUser user, EzyConstant reason) {
        String username = user.getName();
        Lock lock = (Lock)this.locks.computeIfAbsent(username, EzyFunctions.NEW_REENTRANT_LOCK_FUNC);
        lock.lock();
        try {
            this.doRemoveUser(user, reason);
        }
        finally {
            lock.unlock();
            this.locks.remove(username);
        }
    }

    private void doRemoveUser(EzyUser user, EzyConstant reason) {
        this.logger.debug("zone: {} remove user: {} by reason: {}", new Object[]{this.zoneName, user, reason});
        this.removeUser(user);
        this.delegateUserRemove(user, reason);
    }

    public void start() throws Exception {
        this.logger.debug("start user manager for zone: {}", (Object)this.zoneName);
        this.startIdleValidationService();
    }

    protected void startIdleValidationService() {
        if (this.idleValidationService != null) {
            this.idleValidationService.scheduleAtFixedRate(this::validateIdleUsers, this.idleValidationDelay, this.idleValidationInterval, TimeUnit.MILLISECONDS);
        }
    }

    protected void validateIdleUsers() {
        ArrayList<EzyUser> toRemoveUsers = new ArrayList<EzyUser>();
        for (EzyUser user : this.getUserList()) {
            if (!this.isIdleUser(user)) continue;
            toRemoveUsers.add(user);
        }
        for (EzyUser user : toRemoveUsers) {
            this.removeUser(user, EzyDisconnectReason.IDLE);
        }
    }

    protected boolean isIdleUser(EzyUser user) {
        return user.isIdle();
    }

    protected void delegateUserRemove(EzyUser user, EzyConstant reason) {
        this.userDelegate.onUserRemoved(user, reason);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.usersBySession.clear();
        if (this.idleValidationService != null) {
            EzyProcessor.processWithLogException(this.idleValidationService::shutdown);
        }
    }

    @Override
    protected String getMessagePrefix() {
        return "zone: " + this.zoneName;
    }

    public static class Builder
    extends EzyAbstractUserManager.Builder<Builder> {
        protected String zoneName;
        protected long maxIdleTime;
        protected EzyUserDelegate userDelegate;
        protected long idleValidationInterval = 100L;
        protected long idleValidationDelay = 3000L;
        protected int idleValidationThreadPoolSize = 1;

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder maxIdleTime(long maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            return this;
        }

        public Builder userDelegate(EzyUserDelegate userDelegate) {
            this.userDelegate = userDelegate;
            return this;
        }

        public Builder idleValidationDelay(long validationDelay) {
            this.idleValidationDelay = validationDelay;
            return this;
        }

        public Builder idleValidationInterval(long validationInterval) {
            this.idleValidationInterval = validationInterval;
            return this;
        }

        public Builder idleValidationThreadPoolSize(int threadPoolSize) {
            this.idleValidationThreadPoolSize = threadPoolSize;
            return this;
        }

        public EzyZoneUserManager build() {
            return new EzyZoneUserManagerImpl(this);
        }
    }
}

