/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.view;

import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;
import org.youngmonkeys.ezyplatform.manager.EnvironmentManager;

public class VersionalLinkAttributeTagProcessor
extends AbstractAttributeTagProcessor {
    private final String originalAttributeName;
    private final EnvironmentManager environmentManager;

    public VersionalLinkAttributeTagProcessor(String prefix, String originalAttributeName, EnvironmentManager environmentManager) {
        super(TemplateMode.HTML, prefix, null, false, "v" + originalAttributeName, true, Integer.MIN_VALUE, true);
        this.environmentManager = environmentManager;
        this.originalAttributeName = originalAttributeName;
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        Object version = context.getVariable("ezyResourceVersion");
        if (version == null) {
            version = this.environmentManager.getServerStartTime();
        }
        String actualAttributeName = attributeValue;
        if (attributeValue.startsWith("${")) {
            IEngineConfiguration configuration = context.getConfiguration();
            IStandardExpressionParser parser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
            IStandardExpression expression = parser.parseExpression((IExpressionContext)context, attributeValue);
            actualAttributeName = (String)expression.execute((IExpressionContext)context);
        }
        structureHandler.setAttribute(this.originalAttributeName, actualAttributeName + "?v=" + version);
    }
}

