/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.appender;

import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Comparator;
import java.util.List;
import org.youngmonkeys.ezyplatform.admin.appender.AdminDataAppender;
import org.youngmonkeys.ezyplatform.admin.remover.AdminDataRemover;
import org.youngmonkeys.ezyplatform.concurrent.DefaultThreadFactory;

public class AdminDataOperationScheduler
extends EzyLoggable {
    private final EzySingletonFactory singletonFactory;
    private static final int MAX_SLEEP_TIME = 1500;

    public void start() {
        List removerList = this.singletonFactory.getSingletonsOf(AdminDataRemover.class);
        removerList.sort(Comparator.comparingInt(AdminDataRemover::getPriority));
        List appenderList = this.singletonFactory.getSingletonsOf(AdminDataAppender.class);
        appenderList.sort(Comparator.comparingInt(AdminDataAppender::getPriority));
        if (appenderList.isEmpty() && removerList.isEmpty()) {
            return;
        }
        DefaultThreadFactory threadFactory = DefaultThreadFactory.create((String)"data-operation");
        Thread newThread = threadFactory.newThread(() -> {
            long remainSleepTime = 1500L;
            while (true) {
                try {
                    while (true) {
                        if (remainSleepTime > 0L) {
                            Thread.sleep(remainSleepTime);
                        }
                        long startTime = System.currentTimeMillis();
                        for (AdminDataRemover remover : removerList) {
                            remover.remove();
                        }
                        for (AdminDataAppender appender : appenderList) {
                            appender.append();
                        }
                        long endTime = System.currentTimeMillis();
                        long elapsedTime = endTime - startTime;
                        remainSleepTime = 1500L - elapsedTime;
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    this.logger.warn("data operation error", (Throwable)e);
                    continue;
                }
                break;
            }
        });
        newThread.start();
    }

    public AdminDataOperationScheduler(EzySingletonFactory singletonFactory) {
        this.singletonFactory = singletonFactory;
    }
}

