/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.bash;

import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.EzySingletonFactoryAware;
import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.concurrent.EzyExecutors;
import com.tvd12.ezyfox.concurrent.EzyLazyInitializer;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.bash.AdminCommand;
import org.youngmonkeys.ezyplatform.admin.bash.AdminCommandHandler;
import org.youngmonkeys.ezyplatform.admin.bash.Arguments;

@EzySingleton
public class AdminBash
extends EzyLoggable
implements EzySingletonFactoryAware {
    @EzyAutoBind
    private EzySingletonFactory singletonFactory;
    private final ExecutorService executorService = EzyExecutors.newSingleThreadExecutor((String)"bash");
    private final EzyLazyInitializer<Map<AdminCommand, AdminCommandHandler>> handlers = new EzyLazyInitializer(this::createCommandHandlers);

    public void run(AdminCommand command) {
        this.run(command, "");
    }

    public void run(AdminCommand command, String args) {
        this.executorService.execute(() -> this.doRun(command, args));
    }

    private void doRun(AdminCommand command, String args) {
        try {
            AdminCommandHandler handler = (AdminCommandHandler)((Map)this.handlers.get()).get((Object)command);
            Arguments arguments = handler.parse(args);
            if (arguments != null) {
                handler.handle(arguments);
            }
        }
        catch (Exception e) {
            this.logger.error("can not run command: {} with args: {}", new Object[]{command, args, e});
        }
    }

    public Map<AdminCommand, AdminCommandHandler> createCommandHandlers() {
        return this.singletonFactory.getSingletonsOf(AdminCommandHandler.class).stream().collect(Collectors.toMap(AdminCommandHandler::getCommand, it -> it));
    }

    public void setSingletonFactory(EzySingletonFactory singletonFactory) {
        this.singletonFactory = singletonFactory;
    }
}

