/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.config;

import com.tvd12.ezyfox.bean.EzyBeanConfig;
import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.bean.annotation.EzyConfigurationAfter;
import java.util.concurrent.TimeUnit;
import org.youngmonkeys.ezyplatform.admin.appender.AdminDataOperationScheduler;
import org.youngmonkeys.ezyplatform.admin.concurrent.AdminScheduler;
import org.youngmonkeys.ezyplatform.admin.mail.AdminNewPlatformMailScheduler;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEzyPlatformManager;

@EzyConfigurationAfter(priority=0x7FFFFFFF)
public class AdminScheduleRunner
implements EzyBeanConfig {
    @EzyAutoBind
    private AdminScheduler scheduler;
    @EzyAutoBind
    private EzySingletonFactory singletonFactory;
    @EzyAutoBind
    private AdminEzyPlatformManager ezyPlatformManager;
    @EzyAutoBind
    private AdminNewPlatformMailScheduler newPlatformMailScheduler;

    public void config() {
        this.scheduleCacheLatestPlatformVersion();
        this.scheduleAppendData();
        this.scheduleSendNewPlatformMail();
    }

    private void scheduleCacheLatestPlatformVersion() {
        this.ezyPlatformManager.cacheLatestPlatformVersionAsync();
        this.scheduler.scheduleAtFixRate(this.ezyPlatformManager::cacheLatestPlatformVersion, 1L, 1L, TimeUnit.HOURS);
    }

    private void scheduleAppendData() {
        new AdminDataOperationScheduler(this.singletonFactory).start();
    }

    private void scheduleSendNewPlatformMail() {
        this.newPlatformMailScheduler.start();
    }

    public void setScheduler(AdminScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setSingletonFactory(EzySingletonFactory singletonFactory) {
        this.singletonFactory = singletonFactory;
    }

    public void setEzyPlatformManager(AdminEzyPlatformManager ezyPlatformManager) {
        this.ezyPlatformManager = ezyPlatformManager;
    }

    public void setNewPlatformMailScheduler(AdminNewPlatformMailScheduler newPlatformMailScheduler) {
        this.newPlatformMailScheduler = newPlatformMailScheduler;
    }
}

