/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Async;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminDownloadControllerService;
import org.youngmonkeys.ezyplatform.admin.manager.AdminBackupManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEnvironmentManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEzyPlatformManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.admin.validator.AdminPlatformValidator;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

@Api
@Authenticated
@Controller(value="/api/v1")
public class AdminApiPlatformController {
    private final AdminBackupManager backupManager;
    private final AdminFileSystemManager fileSystemManager;
    private final AdminEnvironmentManager environmentManager;
    private final AdminEzyPlatformManager ezyPlatformManager;
    private final AdminDownloadControllerService downloadControllerService;
    private final AdminPlatformValidator platformValidator;

    @DoGet(value="/platform/version")
    public Object platformVersionGet() {
        return EzyMapBuilder.mapBuilder().put((Object)"currentVersion", (Object)this.environmentManager.getPlatformVersion()).put((Object)"latestVersion", (Object)this.ezyPlatformManager.getLatestVersion()).toMap();
    }

    @EzyFeature(value="devops")
    @DoPost(value="/platform/download")
    public ResponseEntity platformDownloadPost() throws Exception {
        if (!this.ezyPlatformManager.hasNewVersion()) {
            throw new HttpNotFoundException(Collections.singletonMap("newPlatformVersion", "notFound"));
        }
        this.ezyPlatformManager.downloadPlatform();
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="devops")
    @DoPost(value="/platform/prepare-to-install")
    public ResponseEntity platformPrepareToInstallPost() throws Exception {
        File ezyPlatformFolder = this.fileSystemManager.getNewEzyPlatformFolder();
        if (!ezyPlatformFolder.exists()) {
            throw new HttpNotFoundException(Collections.singletonMap("newPlatform", "notFound"));
        }
        this.ezyPlatformManager.prepareToInstallPlatform();
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="devops")
    @DoPost(value="/platform/install")
    public ResponseEntity platformInstallPost() throws Exception {
        File ezyPlatformFolder = this.fileSystemManager.getNewEzyPlatformFolder();
        if (!ezyPlatformFolder.exists()) {
            throw new HttpNotFoundException(Collections.singletonMap("newPlatform", "notFound"));
        }
        this.ezyPlatformManager.installPlatform();
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="devops")
    @DoDelete(value="/platform")
    public ResponseEntity platformDelete() {
        File ezyPlatformFolder = this.fileSystemManager.getNewEzyPlatformFolder();
        if (!ezyPlatformFolder.exists()) {
            throw new HttpNotFoundException(Collections.singletonMap("newPlatform", "notFound"));
        }
        FolderProxy.deleteFolder((File)ezyPlatformFolder);
        return ResponseEntity.noContent();
    }

    @Async
    @EzyFeature(value="devops")
    @DoGet(value="/platform/sql")
    public void platformSqlGet(RequestArguments arguments) throws Exception {
        List<File> sqlScripFiles = this.fileSystemManager.getNewEzyplatformAdminScriptFiles();
        this.downloadControllerService.downloadSqlFiles(arguments, sqlScripFiles);
    }

    @EzyFeature(value="devops")
    @DoPost(value="/platform/backups/{versionName}/recover")
    public ResponseEntity platformBackupsVersionNameRecoverPost(@PathVariable String versionName) {
        this.platformValidator.validateBackupVersionName(versionName);
        this.backupManager.recoverBackup(versionName);
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="devops")
    @DoDelete(value="/platform/backups/{versionName}")
    public ResponseEntity platformBackupsVersionNameDelete(@PathVariable String versionName) {
        this.platformValidator.validateBackupVersionName(versionName);
        this.backupManager.deleteBackup(versionName);
        return ResponseEntity.noContent();
    }

    public AdminApiPlatformController(AdminBackupManager backupManager, AdminFileSystemManager fileSystemManager, AdminEnvironmentManager environmentManager, AdminEzyPlatformManager ezyPlatformManager, AdminDownloadControllerService downloadControllerService, AdminPlatformValidator platformValidator) {
        this.backupManager = backupManager;
        this.fileSystemManager = fileSystemManager;
        this.environmentManager = environmentManager;
        this.ezyPlatformManager = ezyPlatformManager;
        this.downloadControllerService = downloadControllerService;
        this.platformValidator = platformValidator;
    }
}

