/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.data.ModuleMetadata;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.io.FolderProxy;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;

@EzySingleton
public class AdminModuleMetadataInteractor
extends EzyLoggable {
    private final ObjectMapper objectMapper;
    private static final Map<ModuleType, String> METADATA_FILES = Collections.unmodifiableMap(EzyMapBuilder.mapBuilder().put((Object)ModuleType.ADMIN_PLUGIN, (Object)"admin/plugins.txt").put((Object)ModuleType.WEB_PLUGIN, (Object)"web/plugins.txt").put((Object)ModuleType.THEME, (Object)"web/themes.txt").put((Object)ModuleType.SOCKET_PLUGIN, (Object)"socket/plugins.txt").put((Object)ModuleType.SOCKET_APP, (Object)"socket/apps.txt").build());

    public Map<ModuleType, Map<String, ModuleMetadata>> read(File runtimeFolder) {
        return Arrays.stream(ModuleType.values()).collect(Collectors.toMap(it -> it, it -> this.readByTarget((ModuleType)it, runtimeFolder)));
    }

    public Map<String, ModuleMetadata> readAdminPluginMetadataMap(String ezyplatformHome) {
        return this.readByTarget(ModuleType.ADMIN_PLUGIN, FileSystemManager.concatWithEzyHome((String)ezyplatformHome, (String)".runtime"));
    }

    public void write(File runtimeFolder, ModuleType moduleType, Map<String, ModuleMetadata> moduleMetadataMap) {
        File modulesFile = this.getModuleMetadataFile(runtimeFolder, moduleType);
        try {
            FolderProxy.createNewFile((File)modulesFile);
            this.objectMapper.writeValue(modulesFile, moduleMetadataMap.values());
        }
        catch (Exception e) {
            this.logger.error("write module metadata: {} of: {} failed", new Object[]{moduleMetadataMap, moduleType, e});
        }
    }

    private Map<String, ModuleMetadata> readByTarget(ModuleType moduleType, File runtimeFolder) {
        File modulesFile = this.getModuleMetadataFile(runtimeFolder, moduleType);
        ModuleMetadata[] moduleMetadataArray = modulesFile.exists() ? this.readModuleMetadata(modulesFile) : new ModuleMetadata[]{};
        return Arrays.stream(moduleMetadataArray).collect(Collectors.toMap(ModuleMetadata::getName, it -> it));
    }

    private ModuleMetadata[] readModuleMetadata(File metadataFile) {
        try {
            return (ModuleMetadata[])this.objectMapper.readValue(metadataFile, ModuleMetadata[].class);
        }
        catch (IOException e) {
            return new ModuleMetadata[0];
        }
    }

    private File getModuleMetadataFile(File runtimeFolder, ModuleType moduleType) {
        return Paths.get(runtimeFolder.toString(), METADATA_FILES.get(moduleType)).toFile();
    }

    public AdminModuleMetadataInteractor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

