/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyStrings;
import java.util.List;
import org.youngmonkeys.ezyplatform.repo.PaginationResultRepository;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.rx.RxOperation;
import org.youngmonkeys.ezyplatform.rx.RxOperationSupplier;
import org.youngmonkeys.ezyplatform.service.PaginationService;
import org.youngmonkeys.ezyplatform.util.Numbers;

public abstract class DefaultPaginationResultService<T, F, P, I, E, R>
extends PaginationService<T, F, P> {
    protected final PaginationResultRepository<F, P, I, E, R> repository;

    @Override
    protected RxOperation getFirstItems(F filter, int limit) {
        return this.convertEntities(this.repository.findFirstElements(filter, limit));
    }

    @Override
    protected RxOperation getNextItemsExclusive(F filter, P paginationParameter, int limit) {
        return this.convertEntities(this.repository.findNextElements(filter, paginationParameter, limit));
    }

    @Override
    protected RxOperation getLastItems(F filter, int limit) {
        return this.convertEntities(this.repository.findLastElements(filter, limit));
    }

    @Override
    protected RxOperation getPreviousItemsExclusive(F filter, P paginationParameter, int limit) {
        return this.convertEntities(this.repository.findPreviousElements(filter, paginationParameter, limit));
    }

    @Override
    protected long getTotalItems(F filter) {
        if (this.allowCountAllItems()) {
            return this.repository.countElements(filter);
        }
        int countLimit = this.getCountLimit();
        List<R> items = this.repository.findFirstElements(filter, countLimit, 1);
        return items.isEmpty() ? this.repository.countElements(filter) : (long)countLimit;
    }

    protected boolean allowCountAllItems() {
        return false;
    }

    protected int getCountLimit() {
        String value = this.repository.findSettingValue("ezyplatform_pagination_count_limit");
        int limit = 0;
        if (EzyStrings.isNotBlank((String)value)) {
            limit = Numbers.toIntOrZero(value);
        }
        if (limit <= 0) {
            limit = 1000000;
        }
        return limit;
    }

    protected RxOperation convertEntities(List<R> entities) {
        Reactive.Single<Object> single = Reactive.single(entities);
        RxOperationSupplier<R> supplier = this.convertEntityRxSupplier();
        if (supplier != null) {
            single.mapItemRx(supplier);
        } else {
            single.mapItem(this::convertEntity);
        }
        return single;
    }

    protected T convertEntity(R entity) {
        return (T)entity;
    }

    protected RxOperationSupplier<R> convertEntityRxSupplier() {
        return null;
    }

    public DefaultPaginationResultService(PaginationResultRepository<F, P, I, E, R> repository) {
        this.repository = repository;
    }
}

