/*
 * Decompiled with CFR 0.152.
 */
package com.ezyplatform.socket.monitor.plugin.data;

import com.tvd12.ezyfox.binding.annotation.EzyObjectBinding;

@EzyObjectBinding(read=false)
public class MemoryPoint {
    private long maxMemory;
    private long freeMemory;
    private long totalMemory;

    public long getAllocatedMemory() {
        return this.totalMemory;
    }

    public long getUsedMemory() {
        return this.totalMemory - this.freeMemory;
    }

    MemoryPoint(long maxMemory, long freeMemory, long totalMemory) {
        this.maxMemory = maxMemory;
        this.freeMemory = freeMemory;
        this.totalMemory = totalMemory;
    }

    public static MemoryPointBuilder builder() {
        return new MemoryPointBuilder();
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public static class MemoryPointBuilder {
        private long maxMemory;
        private long freeMemory;
        private long totalMemory;

        MemoryPointBuilder() {
        }

        public MemoryPointBuilder maxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
            return this;
        }

        public MemoryPointBuilder freeMemory(long freeMemory) {
            this.freeMemory = freeMemory;
            return this;
        }

        public MemoryPointBuilder totalMemory(long totalMemory) {
            this.totalMemory = totalMemory;
            return this;
        }

        public MemoryPoint build() {
            return new MemoryPoint(this.maxMemory, this.freeMemory, this.totalMemory);
        }

        public String toString() {
            return "MemoryPoint.MemoryPointBuilder(maxMemory=" + this.maxMemory + ", freeMemory=" + this.freeMemory + ", totalMemory=" + this.totalMemory + ")";
        }
    }
}

