/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.entity;

import com.tvd12.gamebox.entity.MMOPlayer;
import com.tvd12.gamebox.entity.MMORoom;
import com.tvd12.gamebox.entity.Player;
import com.tvd12.gamebox.math.Vec3;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MMOGridRoom
extends MMORoom {
    private final float maxX;
    private final float maxY;
    private final float maxZ;
    private final float cellSize;
    private final int cellRangeOfInterest;
    private final Map<Player, Cell> cellByPlayer;
    private final Cell[][][] cells;
    private final int maxCellX;
    private final int maxCellY;
    private final int maxCellZ;

    public MMOGridRoom(Builder builder) {
        super(builder);
        this.maxX = builder.maxX;
        this.maxY = builder.maxY;
        this.maxZ = builder.maxZ;
        this.cellSize = builder.cellSize;
        this.cellByPlayer = new ConcurrentHashMap<Player, Cell>();
        this.cellRangeOfInterest = (int)builder.distanceOfInterest;
        this.maxCellX = Math.max(1, (int)(this.maxX / this.cellSize));
        this.maxCellY = Math.max(1, (int)(this.maxY / this.cellSize));
        this.maxCellZ = Math.max(1, (int)(this.maxZ / this.cellSize));
        this.cells = new Cell[this.maxCellX][this.maxCellY][this.maxCellZ];
        this.initializeCells();
    }

    private void initializeCells() {
        for (int ix = 0; ix < this.maxCellX; ++ix) {
            for (int iy = 0; iy < this.maxCellY; ++iy) {
                for (int iz = 0; iz < this.maxCellZ; ++iz) {
                    Cell cell = new Cell();
                    cell.setCellX(ix);
                    cell.setCellY(iy);
                    cell.setCellZ(iz);
                    this.cells[ix][iy][iz] = cell;
                }
            }
        }
    }

    @Override
    public void addPlayer(Player player) {
        super.addPlayer(player);
        this.addPlayerToCell((MMOPlayer)player);
    }

    @Override
    public void removePlayer(Player player) {
        this.cellByPlayer.get(player).removePlayer((MMOPlayer)player);
        this.cellByPlayer.remove(player);
        this.clearCurrentNearbyPlayers((MMOPlayer)player);
        super.removePlayer(player);
    }

    private void clearCurrentNearbyPlayers(MMOPlayer player) {
        for (String otherPlayerName : player.getNearbyPlayerNames()) {
            MMOPlayer otherPlayer = (MMOPlayer)this.playerManager.getPlayer(otherPlayerName);
            if (otherPlayer == null) continue;
            otherPlayer.removeNearByPlayer(player);
        }
        player.clearNearByPlayers();
    }

    private void addPlayerToCell(MMOPlayer player) {
        int cellX = (int)(player.getPosition().x / this.cellSize);
        int cellY = (int)(player.getPosition().y / this.cellSize);
        int cellZ = (int)(player.getPosition().z / this.cellSize);
        this.addPlayerToCell(player, cellX, cellY, cellZ);
    }

    private void addPlayerToCell(MMOPlayer player, int cellX, int cellY, int cellZ) {
        Cell cell = this.cells[cellX][cellY][cellZ];
        cell.addPlayer(player);
        this.cellByPlayer.put(player, cell);
        this.updateNearbyPlayers(player, cellX, cellY, cellZ);
    }

    private void updateNearbyPlayers(MMOPlayer player, int cellX, int cellY, int cellZ) {
        this.clearCurrentNearbyPlayers(player);
        this.handleNeighboringCells(player, cellX, cellY, cellZ);
    }

    private void handleNeighboringCells(MMOPlayer currentPlayer, int cellX, int cellY, int cellZ) {
        int cellOfInterestEndX = Math.min(this.maxCellX - 1, cellX + this.cellRangeOfInterest);
        int cellOfInterestEndY = Math.min(this.maxCellY - 1, cellY + this.cellRangeOfInterest);
        int cellOfInterestEndZ = Math.min(this.maxCellZ - 1, cellZ + this.cellRangeOfInterest);
        int cellOfInterestStartX = Math.max(0, cellX - this.cellRangeOfInterest);
        int cellOfInterestStartY = Math.max(0, cellY - this.cellRangeOfInterest);
        int cellOfInterestStartZ = Math.max(0, cellZ - this.cellRangeOfInterest);
        for (int ix = cellOfInterestStartX; ix <= cellOfInterestEndX; ++ix) {
            for (int iy = cellOfInterestStartY; iy <= cellOfInterestEndY; ++iy) {
                for (int iz = cellOfInterestStartZ; iz <= cellOfInterestEndZ; ++iz) {
                    this.addNearbyPlayersInCell(currentPlayer, this.cells[ix][iy][iz]);
                }
            }
        }
    }

    private void addNearbyPlayersInCell(MMOPlayer currentPlayer, Cell cell) {
        for (MMOPlayer nearByPlayer : cell.players) {
            currentPlayer.addNearbyPlayer(nearByPlayer);
            nearByPlayer.addNearbyPlayer(currentPlayer);
        }
    }

    public void setPlayerPosition(MMOPlayer player, Vec3 position) {
        if (!this.isPositionInsideRoom(position)) {
            throw new IllegalArgumentException("Position is outside of the room's area");
        }
        Cell oldCell = this.cellByPlayer.get(player);
        if (oldCell == null) {
            player.setPosition(position);
            this.addPlayerToCell(player);
            return;
        }
        int cellX = (int)(position.x / this.cellSize);
        int cellY = (int)(position.y / this.cellSize);
        int cellZ = (int)(position.z / this.cellSize);
        player.setPosition(position);
        if (oldCell.cellX != cellX || oldCell.cellY != cellY || oldCell.cellZ != cellZ) {
            oldCell.removePlayer(player);
            this.addPlayerToCell(player, cellX, cellY, cellZ);
        }
    }

    private boolean isPositionInsideRoom(Vec3 position) {
        return position.x >= 0.0f && position.x <= this.maxX && position.y >= 0.0f && position.y <= this.maxY && position.z >= 0.0f && position.z <= this.maxZ;
    }

    @Override
    protected void updatePlayers() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMaxZ() {
        return this.maxZ;
    }

    public float getCellSize() {
        return this.cellSize;
    }

    public int getCellRangeOfInterest() {
        return this.cellRangeOfInterest;
    }

    private static class Cell {
        private int cellX;
        private int cellY;
        private int cellZ;
        private final Set<MMOPlayer> players = ConcurrentHashMap.newKeySet();

        private Cell() {
        }

        public void addPlayer(MMOPlayer player) {
            this.players.add(player);
        }

        public void removePlayer(MMOPlayer player) {
            this.players.remove(player);
        }

        public void setCellX(int cellX) {
            this.cellX = cellX;
        }

        public void setCellY(int cellY) {
            this.cellY = cellY;
        }

        public void setCellZ(int cellZ) {
            this.cellZ = cellZ;
        }
    }

    public static class Builder
    extends MMORoom.Builder {
        private float maxX;
        private float maxY;
        private float maxZ;
        private float cellSize;

        public Builder maxX(float maxX) {
            this.maxX = maxX;
            return this;
        }

        public Builder maxY(float maxY) {
            this.maxY = maxY;
            return this;
        }

        public Builder maxZ(float maxZ) {
            this.maxZ = maxZ;
            return this;
        }

        public Builder cellSize(float cellSize) {
            this.cellSize = cellSize;
            return this;
        }

        @Override
        public Builder distanceOfInterest(double distance) {
            this.distanceOfInterest = distance;
            return this;
        }

        @Override
        protected MMORoom newProduct() {
            return new MMOGridRoom(this);
        }
    }
}

