/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.websocket;

import com.tvd12.ezyfoxserver.constant.EzyConnectionType;
import com.tvd12.ezyfoxserver.nio.websocket.EzyWsCloseStatus;
import com.tvd12.ezyfoxserver.socket.EzyChannel;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EzyWsChannel
implements EzyChannel {
    private final Session session;
    private final SocketAddress serverAddress;
    private final SocketAddress clientAddress;
    private volatile boolean opened = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(EzyWsChannel.class);

    public EzyWsChannel(Session session) {
        this.session = session;
        this.serverAddress = session.getLocalAddress();
        this.clientAddress = session.getRemoteAddress();
    }

    public int write(Object data, boolean binary) throws Exception {
        try {
            if (binary) {
                return this.writeBinary((byte[])data);
            }
            return this.writeString((String)data);
        }
        catch (WebSocketException e) {
            LOGGER.debug("write data: {}, to: {} error", new Object[]{data, this.clientAddress, e});
            return 0;
        }
    }

    private int writeBinary(byte[] bytes) throws Exception {
        int bytesSize = bytes.length;
        RemoteEndpoint remote = this.session.getRemote();
        remote.sendBytes(ByteBuffer.wrap(bytes));
        return bytesSize;
    }

    private int writeString(String bytes) throws Exception {
        int bytesSize = bytes.length();
        RemoteEndpoint remote = this.session.getRemote();
        remote.sendString(bytes);
        return bytesSize;
    }

    public Session getConnection() {
        return this.session;
    }

    public EzyConnectionType getConnectionType() {
        return EzyConnectionType.WEBSOCKET;
    }

    public boolean isConnected() {
        return this.opened;
    }

    public void setClosed() {
        this.opened = false;
    }

    public void disconnect() {
        try {
            this.session.disconnect();
        }
        catch (Exception e) {
            LOGGER.warn("disconnect session: {} error", (Object)this.session, (Object)e);
        }
    }

    public void close() {
        try {
            this.session.close((CloseStatus)EzyWsCloseStatus.CLOSE_BY_SERVER);
        }
        catch (Exception e) {
            LOGGER.warn("close session: {} error", (Object)this.session, (Object)e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public SocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public SocketAddress getClientAddress() {
        return this.clientAddress;
    }

    public boolean isOpened() {
        return this.opened;
    }
}

