/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.interceptor;

import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.exception.HttpForbiddenException;
import com.tvd12.ezyhttp.server.core.manager.FeatureURIManager;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.youngmonkeys.ezyplatform.annotation.AccessToken;
import org.youngmonkeys.ezyplatform.annotation.UserRoles;
import org.youngmonkeys.ezyplatform.data.UserRolesProxy;
import org.youngmonkeys.ezyplatform.web.annotation.UserId;
import org.youngmonkeys.ezyplatform.web.interceptor.WebRequestInterceptor;
import org.youngmonkeys.ezyplatform.web.service.WebRoleFeatureService;
import org.youngmonkeys.ezyplatform.web.service.WebUserRoleService;
import org.youngmonkeys.ezyplatform.web.service.WebUserService;

public class WebAuthenticationInterceptor
extends WebRequestInterceptor {
    @EzyAutoBind
    private WebUserService userService;
    @EzyAutoBind
    private FeatureURIManager featureUriManager;
    @EzyAutoBind
    private WebUserRoleService userRoleService;
    @EzyAutoBind
    private WebRoleFeatureService roleFeatureService;
    protected final Set<String> canBeUseUserIdUris = this.getCanBeUseUserIdUris();

    public boolean validate(RequestArguments arguments, Method handler) {
        String accessToken = arguments.getHeader("accessToken");
        if (accessToken == null) {
            accessToken = arguments.getCookieValue("accessToken");
        }
        if (accessToken == null) {
            accessToken = (String)arguments.getArgument((Object)"accessToken");
        }
        HttpServletRequest request = arguments.getRequest();
        request.setAttribute("accessToken", (Object)accessToken);
        arguments.setArgument(AccessToken.class, (Object)accessToken);
        Long userId = null;
        String uriTemplate = arguments.getUriTemplate();
        HttpMethod method = arguments.getMethod();
        if (this.requestUriManager.isAuthenticatedURI(method, uriTemplate)) {
            userId = this.userService.validateUserAccessToken(accessToken);
            arguments.setArgument(UserId.class, (Object)userId);
            request.setAttribute(UserId.class.getName(), (Object)userId);
        } else if (this.canBeUseUserIdUris.contains(uriTemplate) || this.requestUriManager.isAuthenticatableURI(method, uriTemplate)) {
            userId = this.userService.getUserIdByAccessToken(accessToken);
            arguments.setArgument(UserId.class, (Object)userId);
            request.setAttribute(UserId.class.getName(), (Object)userId);
        }
        if (userId != null && this.needToCheckPermission()) {
            UserRolesProxy userRolesProxy = this.checkPermission(method, uriTemplate, userId);
            arguments.setArgument(UserRoles.class, (Object)userRolesProxy);
            request.setAttribute(UserRoles.class.getName(), (Object)userRolesProxy);
        }
        return true;
    }

    protected boolean needToCheckPermission() {
        return false;
    }

    protected Set<String> getCanBeUseUserIdUris() {
        return Collections.emptySet();
    }

    private UserRolesProxy checkPermission(HttpMethod method, String uriTemplate, long userId) {
        String feature = this.featureUriManager.getFeatureByURI(method, uriTemplate);
        Set roleIds = this.userRoleService.getRoleIdsByUserId(userId);
        Map methodsUriMapByFeatureByRoleId = this.roleFeatureService.getMethodsUriMapByFeatureByRoleId();
        if (feature != null) {
            boolean hasPermission = false;
            for (Long roleId : roleIds) {
                Set methods;
                Map methodsUriMap;
                Map methodsUriMapByFeature = (Map)methodsUriMapByFeatureByRoleId.get(roleId);
                if (methodsUriMapByFeature == null || (methodsUriMap = (Map)methodsUriMapByFeature.get(feature)) == null || (methods = (Set)methodsUriMap.get(uriTemplate)) == null || !methods.contains(method)) continue;
                hasPermission = true;
                break;
            }
            if (!hasPermission) {
                throw new HttpForbiddenException(Collections.singletonMap("permission", "denied"));
            }
        }
        return UserRolesProxy.create((Set)roleIds, (FeatureURIManager)this.featureUriManager, (Map)methodsUriMapByFeatureByRoleId);
    }

    public void setUserService(WebUserService userService) {
        this.userService = userService;
    }

    public void setFeatureUriManager(FeatureURIManager featureUriManager) {
        this.featureUriManager = featureUriManager;
    }

    public void setUserRoleService(WebUserRoleService userRoleService) {
        this.userRoleService = userRoleService;
    }

    public void setRoleFeatureService(WebRoleFeatureService roleFeatureService) {
        this.roleFeatureService = roleFeatureService;
    }
}

