/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.validator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import java.util.HashMap;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.service.UserService;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;
import org.youngmonkeys.ezyplatform.validator.UserValidator;
import org.youngmonkeys.ezyplatform.web.event.WebEventHandlerManager;
import org.youngmonkeys.ezyplatform.web.request.UpdatePasswordRequest;
import org.youngmonkeys.ezyplatform.web.request.UpdateUserRequest;
import org.youngmonkeys.ezyplatform.web.service.WebUserService;

@EzySingleton
public class WebUserValidator
extends UserValidator {
    private final WebEventHandlerManager eventHandlerManager;
    private final WebUserService userService;

    public WebUserValidator(WebEventHandlerManager eventHandlerManager, WebUserService userService) {
        super((UserService)userService);
        this.eventHandlerManager = eventHandlerManager;
        this.userService = userService;
    }

    public void validate(long userId, UpdatePasswordRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        boolean hasAutoGeneratedPassword = this.userService.isUserHasAutoGeneratedPassword(userId);
        if (!hasAutoGeneratedPassword) {
            if (EzyStrings.isBlank((String)request.getOldPassword())) {
                errors.put("password", "required");
            } else if (!DefaultValidator.isValidPassword((String)request.getOldPassword())) {
                errors.put("password", "invalid");
            }
        }
        if (!DefaultValidator.isValidPassword((String)request.getNewPassword())) {
            errors.put("newPassword", "invalid");
        } else if (request.getNewPassword().equals(request.getOldPassword())) {
            errors.put("newPassword", "must_be_difference_old_password");
        }
        this.eventHandlerManager.handleEvent("validate_user_update_password", EzyMapBuilder.mapBuilder().put((Object)"userId", (Object)userId).put((Object)"request", (Object)request).put((Object)"errors", errors).toMap());
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(long userId, UpdateUserRequest request) {
        String displayName;
        String website;
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isEmpty((CharSequence)request.getEmail())) {
            errors.put("email", "required");
        } else if (!DefaultValidator.isValidEmail((String)request.getEmail())) {
            errors.put("email", "invalid");
        } else {
            UserModel userModel = this.userService.getUserByEmail(request.getEmail());
            if (userModel != null && userModel.getId() != userId) {
                errors.put("email", "duplicated");
            }
        }
        String phone = request.getPhone();
        if (EzyStrings.isNotBlank((String)phone)) {
            if (!DefaultValidator.isValidPhone((String)phone)) {
                errors.put("phone", "invalid");
            } else {
                UserModel userModel = this.userService.getUserByPhone(phone.trim());
                if (userModel != null && userModel.getId() != userId) {
                    errors.put("phone", "duplicated");
                }
            }
        }
        if (EzyStrings.isNotBlank((String)(website = request.getWebsite())) && !DefaultValidator.isValidHttpUrl((String)website)) {
            errors.put("website", "invalid");
        }
        if (EzyStrings.isBlank((String)(displayName = request.getDisplayName()))) {
            errors.put("displayName", "required");
        } else if (displayName.length() > 128) {
            errors.put("displayName", "overLength");
        }
        this.eventHandlerManager.handleEvent("validate_user_update", EzyMapBuilder.mapBuilder().put((Object)"userId", (Object)userId).put((Object)"request", (Object)request).put((Object)"errors", errors).toMap());
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }
}

