/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import com.tvd12.ezydata.database.query.EzyQueryConditionBuilder;
import com.tvd12.ezyfox.builder.EzyBuilder;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.pagination.MediaFilter;

public class DefaultMediaFilter
implements MediaFilter {
    public final MediaType type;
    public final Long ownerAdminId;
    public final Long ownerUserId;
    public final String prefixKeyword;
    public final String likeKeyword;

    protected DefaultMediaFilter(Builder<?> builder) {
        this.type = ((Builder)builder).type;
        this.ownerAdminId = ((Builder)builder).ownerAdminId;
        this.ownerUserId = ((Builder)builder).ownerUserId;
        this.prefixKeyword = ((Builder)builder).prefixKeyword;
        this.likeKeyword = ((Builder)builder).likeKeyword;
    }

    public String matchingCondition() {
        EzyQueryConditionBuilder answer = new EzyQueryConditionBuilder();
        if (this.type != null) {
            answer.and("e.type = :type");
        }
        if (this.ownerAdminId != null) {
            answer.and("e.ownerAdminId = :ownerAdminId");
        }
        if (this.ownerUserId != null) {
            answer.and("e.ownerUserId = :ownerUserId");
        }
        if (this.prefixKeyword != null) {
            answer.and("e.originalName LIKE CONCAT(:prefixKeyword,'%')");
        }
        if (this.likeKeyword != null) {
            answer.and("e.originalName LIKE CONCAT('%',:likeKeyword,'%')");
        }
        return answer.build();
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>>
    implements EzyBuilder<DefaultMediaFilter> {
        private MediaType type;
        private Long ownerAdminId;
        private Long ownerUserId;
        private String prefixKeyword;
        private String likeKeyword;

        public T type(MediaType type) {
            this.type = type;
            return (T)this;
        }

        public T ownerAdminId(Long ownerAdminId) {
            this.ownerAdminId = ownerAdminId;
            return (T)this;
        }

        public T ownerUserId(Long ownerUserId) {
            this.ownerUserId = ownerUserId;
            return (T)this;
        }

        public T prefixKeyword(String prefixKeyword) {
            this.prefixKeyword = prefixKeyword;
            return (T)this;
        }

        public T likeKeyword(String likeKeyword) {
            this.likeKeyword = likeKeyword;
            return (T)this;
        }

        public DefaultMediaFilter build() {
            return new DefaultMediaFilter(this);
        }
    }
}

