/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.math;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.util.EzyEntityArrays;
import com.tvd12.gamebox.math.Numbers;

public class Vec3 {
    public float x;
    public float y;
    public float z;
    public static final Vec3 ZERO = new Vec3();
    public static final Vec3 UP = new Vec3(0.0f, 1.0f, 0.0f);
    public static final Vec3 DOWN = new Vec3(0.0f, -1.0f, 0.0f);
    public static final Vec3 LEFT = new Vec3(-1.0f, 0.0f, 0.0f);
    public static final Vec3 RIGHT = new Vec3(1.0f, 0.0f, 0.0f);
    public static final Vec3 FORWARD = new Vec3(0.0f, 0.0f, 1.0f);
    public static final Vec3 BACKWARD = new Vec3(0.0f, 0.0f, -1.0f);

    public Vec3() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vec3(Vec3 v) {
        this(v.x, v.y, v.z);
    }

    public Vec3(float[] array) {
        this(array[0], array[1], array[2]);
    }

    public Vec3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void add(Vec3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public void set(float xx, float yy, float zz) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    public void set(double xx, double yy, double zz) {
        this.x = (float)xx;
        this.y = (float)yy;
        this.z = (float)zz;
    }

    public void set(double[] array) {
        this.x = (float)array[0];
        this.y = (float)array[1];
        this.z = (float)array[2];
    }

    public void set(Vec3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void subtract(Vec3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public void multiply(double value) {
        this.x = (float)((double)this.x * value);
        this.y = (float)((double)this.y * value);
        this.z = (float)((double)this.z * value);
    }

    public double distance(Vec3 v) {
        double dx = v.x - this.x;
        double dy = v.y - this.y;
        double dz = v.z - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float distanceSquare(Vec3 v) {
        float dx = this.x - v.x;
        float dy = this.y - v.y;
        float dz = this.z - v.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public boolean equals(Object obj) {
        Vec3 other = (Vec3)obj;
        return Numbers.equals(this.x, other.x) && Numbers.equals(this.y, other.y) && Numbers.equals(this.z, other.z);
    }

    public int hashCode() {
        int hashCode = 31 + Float.hashCode(this.x);
        hashCode += 31 * hashCode + Float.hashCode(this.y);
        hashCode += 31 * hashCode + Float.hashCode(this.z);
        return hashCode;
    }

    public float[] toFloatArray() {
        return new float[]{this.x, this.y, this.z};
    }

    public EzyArray toArray() {
        return EzyEntityArrays.newArray((Object[])new Object[]{Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z)});
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }
}

